Attribute VB_Name = "mGlobal"
Option Explicit

Dim oOrb As New cOrbImpl

Dim sOldManagerIOR As String
Dim oDBManager As c_DBManager
Dim oDBConnection As c_DBConnection

Public Sub initOrb(ByVal oEx As cOrbException)
    Call oOrb.init(oEx)
    If oEx.isSet Then Exit Sub
    'Call oOrb.run(oEx, False)
End Sub

Public Sub initDBManager(ByVal oEx As cOrbException, ByVal sIOR As String)
    If oDBManager Is Nothing Or sOldManagerIOR <> sIOR Then
        Dim oObjRef As cOrbObjRef
        Set oObjRef = oOrb.string_to_object(oEx, sIOR)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Set oDBManager = New c_DBManager
        Set oDBManager = oDBManager.narrow(oEx, oObjRef)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        sOldManagerIOR = sIOR
    End If
    Exit Sub
ExHandler:
    Set oDBManager = Nothing
End Sub

Public Sub shutdownServer(ByVal oEx As cOrbException)
    If oDBManager Is Nothing Then
        Call oEx.setMe("No valid DBManager. Please fill up IOR field.")
        GoTo ExHandler
    End If
    Call oDBManager.shutdownServer(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
End Sub

Public Sub openDBConnection(ByVal oEx As cOrbException, ByVal sURL As String, _
    ByVal sUser As String, ByVal sPassword As String, ByRef oDBWarns As c_SeqDBWarning)
    If oDBManager Is Nothing Then
        Call oEx.setMe("No valid DBManager. Please fill up IOR field.")
        GoTo ExHandler
    End If
    Set oDBConnection = oDBManager.getConnection(oEx, sURL, sUser, _
        sPassword, oDBWarns)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Set oDBConnection = Nothing
End Sub

Public Sub showExeptionBox(ByVal oEx As cOrbException)
    Select Case TypeName(oEx.Kind)
    Case "c_DBException"
        Dim oDBEx As c_DBException
        Set oDBEx = oEx.Kind
        Call MsgBox("DBException " & oDBEx.sqlcode & ", " _
            & oDBEx.sqlstate & vbCrLf & oDBEx.sqlmessage)
    Case Else
        Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
    End Select
End Sub

Public Sub closeDBConnection(ByVal oEx As cOrbException, _
    ByRef oDBWarns As c_SeqDBWarning)
    Call oDBConnection.s_close(oEx, oDBWarns)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Set oDBConnection = Nothing
    Exit Sub
ExHandler:
End Sub

Public Property Get DBConnection() As c_DBConnection
    Set DBConnection = oDBConnection
End Property
