VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_DBManagerImpl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v70. Copyright (c) 1999 Martin.Both
'Source File Name: ../demo/database/database.idl

Option Explicit

Implements cOrbSkeleton

'interface ::DB::Manager
Const sTypeId As String = "IDL:DB/Manager:1.0"
Private oObjRef As cOrbObjRef

'Used by shutdown function
Private oServer As cOrbImpl

Public Property Get TypeId() As String
    TypeId = sTypeId
End Property

Public Property Get ObjRef() As cOrbObjRef
    Set ObjRef = oObjRef
End Property

Private Property Get cOrbSkeleton_TypeId() As String
    cOrbSkeleton_TypeId = sTypeId
End Property

Private Property Get cOrbSkeleton_ObjRef() As cOrbObjRef
    Set cOrbSkeleton_ObjRef = oObjRef
End Property

Private Property Set cOrbSkeleton_ObjRef(ByVal newObjRef As cOrbObjRef)
    Set oObjRef = newObjRef
End Property

'Helper
Public Function cOrbSkeleton_execute(ByVal oEx As cOrbException, ByVal sOperation As String, _
    ByVal oIn As cOrbStream, ByVal oOut As cOrbStream) As Long
    On Error GoTo ErrHandler
    Select Case sOperation
    Case "getConnection"
        Dim a1_url As String
        a1_url = oIn.read_string(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Dim a1_user As String
        a1_user = oIn.read_string(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Dim a1_password As String
        a1_password = oIn.read_string(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Dim a1_warns As c_SeqDBWarning
        Dim getConnection As c_DBConnection
        Set getConnection = Me.getConnection(oEx, a1_url, a1_user, a1_password, a1_warns _
            )
        If oEx.isSet Then
            Select Case TypeName(oEx.Kind)
            Case "c_DBException"
                Dim oUserEx1_0 As c_DBException
                Set oUserEx1_0 = oEx.Kind
                Call oEx.unSet
                Call oUserEx1_0.writeMe(oEx, oOut)
                If oEx.isSet Then
                    GoTo ExHandler
                End If
                cOrbSkeleton_execute = 1 'USER_EXCEPTION
                Exit Function
            Case Else
                GoTo ExHandler
            End Select
        End If
        If getConnection Is Nothing Then
            Call oOut.write_ObjRef(oEx, Nothing)
        Else
            Call getConnection.writeMe(oEx, oOut)
        End If
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call a1_warns.writeMe(oEx, oOut, 0)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    Case "shutdownServer"
        Call Me.shutdownServer(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    Case Else
        Dim oSystemEx As New cOrbSystemException
        Call oSystemEx.setBADOPERATION(1, oSystemEx.CompletedNO)
        Call oEx.setMe(oSystemEx.Description, Kind:=oSystemEx)
        GoTo ExHandler
    End Select
    cOrbSkeleton_execute = 0 'NO_EXCEPTION
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("executeManager: ")
End Function

'Implements c_DBManager

'getConnection()
Public Function getConnection(ByVal oEx As cOrbException, ByVal url As String, ByVal user As String _
    , ByVal password As String, ByRef warns As c_SeqDBWarning) As c_DBConnection
    Dim oDBEx As c_DBException
    If StrConv(user, vbLowerCase) <> "petra" Then
        Set oDBEx = New c_DBException
        oDBEx.sqlcode = -977
        oDBEx.sqlstate = "EE977"
        oDBEx.sqlmessage = "Unknown user " & user & ". (Only Petra is known.)"
        Call oEx.setMe(oDBEx.Description, Kind:=oDBEx)
        GoTo ExHandler
    End If
    If StrConv(password, vbLowerCase) <> "geheim" Then
        Set oDBEx = New c_DBException
        oDBEx.sqlcode = -978
        oDBEx.sqlstate = "EE978"
        oDBEx.sqlmessage = "User " & user & " not authorized. (Wrong password.)"
        Call oEx.setMe(oDBEx.Description, Kind:=oDBEx)
        GoTo ExHandler
    End If
    'Do a connection
    Dim oDBConnImpl As New c_DBConnectionImpl
    Call oObjRef.Orb.connect(oEx, oDBConnImpl)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    'Returning warnings if any
    Set warns = New c_SeqDBWarning
    warns.Length = 2
    Set warns.Item(1) = New c_DBWarning
    warns.Item(1).sqlcode = 222
    warns.Item(1).sqlstate = "IW222"
    warns.Item(1).sqlmessage = "Connected to Visual Basic demo database"
    Set warns.Item(2) = New c_DBWarning
    warns.Item(2).sqlcode = 223
    warns.Item(2).sqlstate = "IW223"
    warns.Item(2).sqlmessage = "Connected to DB-URL " & url
    'Returning a reference of the connection object
    Set getConnection = New c_DBConnection
    Set getConnection = getConnection.narrow(oEx, oDBConnImpl.ObjRef)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ExHandler:
    Call oEx.addPrefix("getConnection: ")
    Set getConnection = Nothing
End Function

'oneway shutdownServer()
Public Sub shutdownServer(ByVal oEx As cOrbException)
    Call oObjRef.Orb.shutdown
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("shutdownServer: ")
End Sub
