VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_SeqByte"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v70. Copyright (c) 1999 Martin.Both
'Source File Name: ../demo/database/database.idl

Option Explicit

'IDL Name: <sequence octet >
Private seqLen As Long
Private seqMax As Long
Private seqArr() As Byte
Private seqIsDim As Boolean

Public Property Get Length() As Long
    Length = seqLen
End Property

Public Property Let Length(ByVal newLen As Long)
    If newLen <= 0 Then
        seqLen = 0
        Erase seqArr
        seqIsDim = False
    Else
        If seqMax > 0 And newLen > seqMax Then
            newLen = seqMax
        End If
        seqLen = newLen
        If seqIsDim Then
            If newLen > UBound(seqArr) Then
                Dim newUBound As Long
                newUBound = UBound(seqArr) * 2
                If seqMax > 0 And newUBound > seqMax Then
                    newUBound = seqMax
                End If
                If newLen > newUBound Then
                    newUBound = newLen
                End If
                ReDim Preserve seqArr(1 To newUBound)
            End If
        Else
            ReDim seqArr(1 To newLen)
            seqIsDim = True
        End If
    End If
End Property

Public Property Get Boundary() As Long
    Boundary = seqMax
End Property

'index must be in the range of 1 to Length
Public Property Get Item(ByVal index As Long) As Byte
    Let Item = seqArr(index)
End Property

'index must be in the range of 1 to Length
Public Property Let Item(ByVal index As Long, ByVal Item As Byte)
    Let seqArr(index) = Item
End Property

Public Function getItems(ByRef Arr() As Byte) As Long
    getItems = seqLen
    Dim seqCnt As Long
    For seqCnt = 1 To seqLen
        Let Arr(LBound(Arr) - 1 + seqCnt) = seqArr(seqCnt)
    Next seqCnt
End Function

Public Sub setItems(ByRef Arr() As Byte, ByVal newLen As Long)
    Me.Length = newLen
    Dim seqCnt As Long
    For seqCnt = 1 To seqLen
        Let seqArr(seqCnt) = Arr(LBound(Arr) - 1 + seqCnt)
    Next seqCnt
End Sub

'Helper
Public Sub readMe(ByVal oEx As cOrbException, ByVal oIn As cOrbStream, ByVal maxLen As Long)
On Error GoTo ErrHandler
    seqMax = maxLen
    Dim newLen As Long
    newLen = oIn.read_ulong(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    If seqMax > 0 And newLen > seqMax Then
        Call oEx.setMe(newLen & " > " & seqMax)
        GoTo ExHandler
    End If
    seqIsDim = False
    Me.Length = newLen
    Call oIn.readOctets(oEx, seqArr, seqLen)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("read_SeqByte: ")
End Sub

'Helper
Public Sub writeMe(ByVal oEx As cOrbException, ByVal oOut As cOrbStream, ByVal maxLen As Long)
On Error GoTo ErrHandler
    seqMax = maxLen
    If seqMax > 0 And seqLen > seqMax Then
        Call oEx.setMe(seqLen & " > " & seqMax)
        GoTo ExHandler
    End If
    Call oOut.write_ulong(oEx, seqLen)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call oOut.writeOctets(oEx, seqArr, seqLen)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("write_SeqByte: ")
End Sub
