Attribute VB_Name = "mDBServer"
Option Explicit

Public oTableHead As c_SeqDBColumnDescriptor
Public oTableRows As c_SeqSeqDBColumnData

Public Sub Main()
    On Error GoTo ErrHandler
    
    Dim sLogFile As String
    sLogFile = "DBServer.log"
    
    Call errorLog(sLogFile, "Starting Server")
    Call loadTable
    
    Dim oEx As New cOrbException
    Dim oOrb As New cOrbImpl
    'PortNo = 900
    Call oOrb.init(oEx, "900")
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    Dim oImpl As New c_DBManagerImpl
    'ObjectKey = "DBManager"
    'iioploc://1.1@HostName:900/DBManager
    Call oOrb.connect(oEx, oImpl, "DBManager")
    If oEx.isSet Then
        GoTo ExHandler
    End If

    'Waiting for client connections
    Call oOrb.run(oEx, True, sLogFile)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    'Disconnect DBManager
    Call oOrb.disconnect(oEx, oImpl)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    Call errorLog(sLogFile, "End of Server")
    End
ErrHandler:
    Call errorLog(sLogFile, _
        "Error: " & Err.Number & ", " & Err.Description)
    Call errorLog(sLogFile, "End of Server")
    End
ExHandler:
    Call errorLog(sLogFile, _
        "Exception: " & oEx.Number & ", " & oEx.Description)
    Call errorLog(sLogFile, "End of Server")
End Sub

Public Sub errorLog(ByVal sLogFile As String, ByVal sMessage As String)
    Dim iFileNo As Integer
    iFileNo = FreeFile
    Open sLogFile For Append As #iFileNo
    Print #iFileNo, Now & " " & sMessage
    Close #iFileNo
End Sub

Public Sub loadTable()
    Set oTableHead = New c_SeqDBColumnDescriptor
    oTableHead.Length = 3
    Set oTableHead.Item(1) = New c_DBColumnDescriptor
    oTableHead.Item(1).name = "Id"
    Set oTableHead.Item(2) = New c_DBColumnDescriptor
    oTableHead.Item(2).name = "Name"
    Set oTableHead.Item(3) = New c_DBColumnDescriptor
    oTableHead.Item(3).name = "Ort"

    Set oTableRows = New c_SeqSeqDBColumnData
    Call insertRow(100, "Martin", "Berlin")
    Call insertRow(101, "Anke", "Mnchen")
    Call insertRow(102, "Sabine", "Hamburg")
    Call insertRow(103, "Manfred", "Hannover")
End Sub

Public Sub insertRow(ByVal lId As Long, ByVal sName As String, ByVal sOrt As String)
    Dim oRow As New c_SeqDBColumnData
    oRow.Length = 3
    Set oRow.Item(1) = New c_DBColumnData
    Call oRow.Item(1).set_integerValue(lId)
    Set oRow.Item(2) = New c_DBColumnData
    Call oRow.Item(2).set_stringValue(sName)
    Set oRow.Item(3) = New c_DBColumnData
    Call oRow.Item(3).set_stringValue(sOrt)
    
    oTableRows.Length = oTableRows.Length + 1
    Set oTableRows.Item(oTableRows.Length) = oRow
End Sub

Public Function updateOrtByName(ByVal sOrt As String, ByVal sName As String) _
    As Long
    Dim oRow As c_SeqDBColumnData
    Dim rowcnt As Long
    For rowcnt = 1 To oTableRows.Length
        Set oRow = oTableRows.Item(rowcnt)
        If oRow.Item(2).get_stringValue = sName Then
            Call oRow.Item(3).set_stringValue(sOrt)
            updateOrtByName = updateOrtByName + 1
        End If
    Next rowcnt
End Function

Public Function deleteName(ByVal sName As String) As Long
    Dim oRow As c_SeqDBColumnData
    Dim rowcnt As Long
    rowcnt = 1
    Do While rowcnt <= oTableRows.Length
        Set oRow = oTableRows.Item(rowcnt)
        If oRow.Item(2).get_stringValue = sName Then
            Dim mvCnt As Long
            mvCnt = rowcnt + 1
            Do While mvCnt <= oTableRows.Length
                Set oTableRows.Item(mvCnt - 1) = oTableRows.Item(mvCnt)
                mvCnt = mvCnt + 1
            Loop
            Set oTableRows.Item(oTableRows.Length) = Nothing
            deleteName = deleteName + 1
            oTableRows.Length = oTableRows.Length - 1
        Else
            rowcnt = rowcnt + 1
        End If
    Loop
End Function

