VERSION 5.00
Begin VB.Form fGridClient 
   Caption         =   "Grid Example Client"
   ClientHeight    =   4935
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5805
   LinkTopic       =   "Form1"
   ScaleHeight     =   4935
   ScaleWidth      =   5805
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Frame Frame1 
      Caption         =   "Call MyServer"
      Height          =   1815
      Left            =   120
      TabIndex        =   8
      Top             =   1320
      Width           =   5535
      Begin VB.CommandButton cmdAnyTest 
         Caption         =   "AnyTest"
         Height          =   375
         Left            =   120
         TabIndex        =   14
         Top             =   1320
         Width           =   1335
      End
      Begin VB.CommandButton cmdOpWithEx 
         Caption         =   "opWithException()"
         Height          =   375
         Left            =   3720
         TabIndex        =   13
         Top             =   240
         Width           =   1695
      End
      Begin VB.CommandButton cmdNonExistent 
         Caption         =   "_non_existent()"
         Height          =   375
         Left            =   120
         TabIndex        =   12
         Top             =   240
         Width           =   1335
      End
      Begin VB.CommandButton cmdWidth 
         Caption         =   "Width()"
         Height          =   375
         Left            =   2640
         TabIndex        =   11
         Top             =   240
         Width           =   975
      End
      Begin VB.CommandButton cmdHeight 
         Caption         =   "Height()"
         Height          =   375
         Left            =   1560
         TabIndex        =   10
         Top             =   240
         Width           =   975
      End
      Begin VB.CommandButton cmdShutdownServer 
         Caption         =   "shutdownServer()"
         Height          =   375
         Left            =   3720
         TabIndex        =   9
         Top             =   1320
         Width           =   1695
      End
   End
   Begin VB.Frame frLogin 
      Caption         =   "URL of MyServer"
      Height          =   1095
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   5535
      Begin VB.CommandButton cmdVersion 
         Caption         =   "Version"
         Height          =   375
         Left            =   1200
         TabIndex        =   7
         Top             =   600
         Width           =   975
      End
      Begin VB.CommandButton cmdAddress 
         Caption         =   "Address"
         Height          =   375
         Left            =   2280
         TabIndex        =   6
         Top             =   600
         Width           =   975
      End
      Begin VB.CommandButton cmdObjKey 
         Caption         =   "ObjectKey"
         Height          =   375
         Left            =   3360
         TabIndex        =   5
         Top             =   600
         Width           =   975
      End
      Begin VB.CommandButton cmdTypeId 
         Caption         =   "TypeId"
         Height          =   375
         Left            =   4440
         TabIndex        =   4
         Top             =   600
         Width           =   975
      End
      Begin VB.CommandButton cmdIOR 
         Caption         =   "IOR"
         Height          =   375
         Left            =   120
         TabIndex        =   3
         Top             =   600
         Width           =   855
      End
      Begin VB.TextBox tbLogin 
         Height          =   285
         Left            =   120
         TabIndex        =   2
         Text            =   "iioploc://1.1@localhost:900/MyServer"
         Top             =   240
         Width           =   5295
      End
   End
   Begin VB.TextBox txtOutput 
      Height          =   1575
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Beides
      TabIndex        =   0
      Top             =   3240
      Width           =   5535
   End
End
Attribute VB_Name = "fGridClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private oOrb As New cOrbImpl
Private oMyServer As c_gridMyServer
Private oTestAny As c_TestAny
Private lineCnt As Integer

Private Sub Form_Load()
    Dim oEx As New cOrbException
    Call oOrb.init(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    lineCnt = 0
    Call initMyServer(tbLogin.Text)
    Exit Sub
ExHandler:
    Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
End Sub

Private Sub tbLogin_LostFocus()
    Call initMyServer(tbLogin.Text)
End Sub

'Initialies the start object (oMyServer) by a String
Private Sub initMyServer(ByVal sURL As String)
    Dim oEx As New cOrbException
    Dim oObjRef As cOrbObjRef
    
    Set oObjRef = oOrb.string_to_object(oEx, sURL)
    If oEx.isSet Then
        Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
        Set oMyServer = Nothing
        Exit Sub
    End If
    
    If oObjRef.TypeId = "IDL:TestAny:1.0" Then
        Set oMyServer = Nothing
        Set oTestAny = New c_TestAny
        Call oTestAny.narrow(oEx, oObjRef)
        If oEx.isSet Then
            Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
            Set oMyServer = Nothing
            Exit Sub
        End If
    Else
        Set oTestAny = Nothing
        Set oMyServer = New c_gridMyServer
        Call oMyServer.narrow(oEx, oObjRef)
        If oEx.isSet Then
            Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
            Set oMyServer = Nothing
            Exit Sub
        End If
    End If
End Sub

'Display a message
Private Sub printLine(ByVal sLine As String)
    If lineCnt >= 6 Then
        lineCnt = 0
        txtOutput.Text = ""
    End If
    lineCnt = lineCnt + 1
    txtOutput.Text = txtOutput.Text & sLine & vbCrLf
End Sub

'Build an IOR string
Private Sub cmdIOR_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Dim oEx As New cOrbException
    Dim sIOR As String
    sIOR = oOrb.object_to_string(oEx, oMyServer.ObjRef)
    If oEx.isSet Then
        Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
        Exit Sub
    End If
    Call printLine(sIOR)
End Sub

'Extract the IIOP version
Private Sub cmdVersion_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Call printLine(oMyServer.ObjRef.IIOPVersion)
End Sub

'Extract the IP address (host and portno)
Private Sub cmdAddress_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Call printLine(oMyServer.ObjRef.IIOPAddress)
End Sub

'Extract the object key
Private Sub cmdObjKey_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Call printLine(oMyServer.ObjRef.objectKey)
End Sub

'Extract the type ID
Private Sub cmdTypeId_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Call printLine(oMyServer.ObjRef.TypeId)
End Sub

'Call a remote method to get the height of the grid
Private Sub cmdHeight_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Dim oEx As New cOrbException
    Dim result As String
    result = "Height: " & oMyServer.height(oEx)
    If oEx.isSet Then
        Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
        Exit Sub
    End If
    Call printLine(result)
End Sub

'Call a remote method to get the width of the grid
Private Sub cmdWidth_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Dim oEx As New cOrbException
    Dim result As String
    result = "Width: " & oMyServer.width(oEx)
    If oEx.isSet Then
        Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
        Exit Sub
    End If
    Call printLine(result)
End Sub

'Call a remote method to get a user exception
Private Sub cmdOpWithEx_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Dim oEx As New cOrbException
    'Call a method returning a user exception
    Call oMyServer.opWithException(oEx)
    If oEx.isSet Then
        Select Case TypeName(oEx.Kind)
        Case "c_gridMyServerMyException"
            Dim oUserEx As c_gridMyServerMyException
            Set oUserEx = oEx.Kind
            Call oEx.unSet
            Call printLine(oUserEx.Description & ": " & oUserEx.why)
        Case Else
            Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
            Exit Sub
        End Select
    End If
End Sub

'Call a remote oneway method to shutdown the server
Private Sub cmdShutdownServer_Click()
    If oMyServer Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Dim oEx As New cOrbException
    Call oMyServer.shutdownServer(oEx)
    If oEx.isSet Then
        Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
        Exit Sub
    End If
End Sub

'Call a remote method to send and receive any types
Private Sub cmdAnyTest_Click()
    If oTestAny Is Nothing Then
        Call MsgBox("No valid object IOR")
        Exit Sub
    End If
    Dim oEx As New cOrbException
    Dim oAny1, oAny2 As cOrbAny
    Set oAny1 = New cOrbAny
    Call oAny1.setStruct("TestStruct", 2)
    Call oAny1.setStructMVal(1, New cOrbAny)
    Call oAny1.getStructMVal(1).setString("Hallo")
    Call oAny1.setStructMVal(2, New cOrbAny)
    Call oAny1.getStructMVal(2).setLong(123)
    Set oAny2 = oTestAny.f_print(oEx, oAny1)
    If oEx.isSet Then
        Call MsgBox("Error " & oEx.Number & vbCrLf & oEx.Description)
        Exit Sub
    End If
    If oAny2.isStruct Then
        Call printLine("Any is a struct " & oAny2.getStructName() & _
            ", " & oAny2.getStructCnt())
        Dim lcnt As Long
        For lcnt = 1 To oAny2.getStructCnt()
            Dim oMem As cOrbAny
            Set oMem = oAny2.getStructMVal(lcnt)
            Call printLine("Member " & oAny2.getStructMName(lcnt) & _
            "= " & IIf(oMem.isString(), oMem.getString, oMem.getLong))
        Next lcnt
    Else
        Call printLine("Any is not a struct")
    End If
End Sub

