Attribute VB_Name = "mGridServer"
Option Explicit

Public Sub Main()
    On Error GoTo ErrHandler
    
    Dim sLogFile As String
    sLogFile = "GridServer.log"
    
    Call errorLog(sLogFile, "Starting Server")
    
    Dim oEx As New cOrbException
    Dim oOrb As New cOrbImpl
    'PortNo = 900
    Call oOrb.init(oEx, "900")
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    Dim oImpl As New c_gridMyServerImpl
    'ObjectKey = "MyServer"
    'iioploc://1.1@HostName:900/MyServer
    Call oOrb.connect(oEx, oImpl, "MyServer")
    If oEx.isSet Then
        GoTo ExHandler
    End If

    'Waiting for client connections
    Call oOrb.run(oEx, True, sLogFile)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    Call oOrb.disconnect(oEx, oImpl)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    Call errorLog(sLogFile, "End of Server")
    End
ErrHandler:
    Call errorLog(sLogFile, _
        "Error: " & Err.Number & ", " & Err.Description)
    Call errorLog(sLogFile, "End of Server")
    End
ExHandler:
    Call errorLog(sLogFile, _
        "Exception: " & oEx.Number & ", " & oEx.Description)
    Call errorLog(sLogFile, "End of Server")
End Sub

Public Sub errorLog(ByVal sLogFile As String, ByVal sMessage As String)
    Dim iFileNo As Integer
    iFileNo = FreeFile
    Open sLogFile For Append As #iFileNo
    Print #iFileNo, Now & " " & sMessage
    Close #iFileNo
End Sub
