VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbAny"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Copyright (c) 2000 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.

Option Explicit

Const tk_null As Long = 0
Const tk_void As Long = 1
Const tk_short As Long = 2
Const tk_long As Long = 3
Const tk_ushort As Long = 4
Const tk_ulong As Long = 5
Const tk_float As Long = 6
Const tk_double As Long = 7
Const tk_boolean As Long = 8
Const tk_char As Long = 9
Const tk_octet As Long = 10
Const tk_any As Long = 11
Const tk_TypeCode As Long = 12
Const tk_Principal As Long = 13
Const tk_objref As Long = 14
Const tk_struct As Long = 15
Const tk_union As Long = 16
Const tk_enum As Long = 17
Const tk_string As Long = 18
Const tk_sequence As Long = 19
Const tk_array As Long = 20
Const tk_alias As Long = 21
Const tk_except As Long = 22
Const tk_longlong As Long = 23
Const tk_ulonglong As Long = 24
Const tk_longdouble As Long = 25
Const tk_wchar As Long = 26
Const tk_wstring As Long = 27
Const tk_fixed As Long = 28
Const tk_value As Long = 29
Const tk_value_box As Long = 30
Const tk_native As Long = 31
Const tk_abstract_interface As Long = 32
Const tk_recursive As Long = &HFFFFFFFF

Private lTypeCode As Long 'tk_... value

Private iVal As Integer
Private lVal As Long
Private oVal As cOrbObjRef
Private sVal As String
Private anyValue As Variant

Private sTypeId As String
Private sTypeName As String

Private sMemberNames() As String
Private aMemberVals() As cOrbAny

'
Public Property Get TCKind() As Long
    TCKind = lTypeCode
End Property

'
Public Property Let TCKind(ByVal tk As Long)
    lTypeCode = tk
End Property

Public Sub setNull()
    lTypeCode = tk_null
    Set oVal = Nothing
    sVal = ""
    Erase sMemberNames
    Erase aMemberVals
End Sub

Public Function isNull() As Boolean
    isNull = (lTypeCode = tk_null)
End Function

Public Sub setShort(ByVal val As Integer)
    lTypeCode = tk_short
    iVal = val
End Sub

Public Function isShort() As Boolean
    isShort = (lTypeCode = tk_short)
End Function

Public Function getShort() As Integer
    getShort = iVal
End Function

Public Sub setLong(ByVal val As Long)
    lTypeCode = tk_long
    lVal = val
End Sub

Public Function isLong() As Boolean
    isLong = (lTypeCode = tk_long)
End Function

Public Function getLong() As Integer
    getLong = lVal
End Function

Public Sub setObjRef(ByVal name As String, ByVal val As cOrbObjRef)
    lTypeCode = tk_objref
    Set oVal = val
    sTypeId = oVal.TypeId
    sTypeName = name
End Sub

Public Function isObjRef() As Boolean
    isObjRef = (lTypeCode = tk_objref)
End Function

Public Function getObjRefName() As String
    getObjRefName = sTypeName
End Function

Public Function getObjRef() As cOrbObjRef
    Set getObjRef = oVal
End Function

Public Sub setStruct(ByVal name As String, ByVal lcnt As Long)
    lTypeCode = tk_struct
    sTypeId = ""
    sTypeName = name
    ReDim sMemberNames(1 To lcnt)
    ReDim aMemberVals(1 To lcnt)
End Sub

Public Sub setStructMName(ByVal indx As Long, ByVal name As String)
    sMemberNames(indx) = name
End Sub

Public Sub setStructMVal(ByVal indx As Long, ByVal val As cOrbAny)
    Set aMemberVals(indx) = val
End Sub

Public Function isStruct() As Boolean
    isStruct = (lTypeCode = tk_struct)
End Function

Public Function getStructName() As String
    getStructName = sTypeName
End Function

Public Function getStructCnt() As Long
    getStructCnt = UBound(sMemberNames) - LBound(sMemberNames) + 1
End Function

Public Function getStructMName(ByVal indx As Long) As String
    getStructMName = sMemberNames(indx)
End Function

Public Function getStructMVal(ByVal indx As Long) As cOrbAny
    Set getStructMVal = aMemberVals(indx)
End Function

Public Sub setString(ByVal val As String)
    lTypeCode = tk_string
    sVal = val
End Sub

Public Function isString() As Boolean
    isString = (lTypeCode = tk_string)
End Function

Public Function getString() As String
    getString = sVal
End Function

'Helper
Public Sub readMe(ByVal oEx As cOrbException, ByVal oIn As cOrbStream)
    Call readType(oEx, oIn)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call readValue(oEx, oIn)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readAny: ")
End Sub

'Helper
Public Sub readType(ByVal oEx As cOrbException, ByVal oIn As cOrbStream)
    lTypeCode = oIn.read_long(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Select Case lTypeCode
    Case tk_null To tk_Principal, tk_longlong To tk_wchar
    Case tk_objref
        lVal = oIn.read_ulong(oEx)  ' complex type
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oIn.readEncapOpen(oEx, lVal)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        sTypeId = oIn.read_string(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        sTypeName = oIn.read_string(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oIn.readEncapClose(oEx)
    Case tk_struct
        lVal = oIn.read_ulong(oEx)  ' complex type
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oIn.readEncapOpen(oEx, lVal)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        sTypeId = oIn.read_string(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        sTypeName = oIn.read_string(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        lVal = oIn.read_ulong(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        ReDim sMemberNames(1 To lVal)
        ReDim aMemberVals(1 To lVal)
        For lVal = LBound(sMemberNames) To UBound(sMemberNames)
            sMemberNames(lVal) = oIn.read_string(oEx)
            If oEx.isSet Then
                GoTo ExHandler
            End If
            Set aMemberVals(lVal) = New cOrbAny
            Call aMemberVals(lVal).readType(oEx, oIn)
            If oEx.isSet Then
                GoTo ExHandler
            End If
        Next lVal
        Call oIn.readEncapClose(oEx)
    Case tk_string
        Call oIn.read_ulong(oEx)  'max length
    Case Else
        Call oEx.setMe("Any type " & lTypeCode & " is unsupported")
    End Select
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readType: ")
End Sub

'Helper
Public Sub readValue(ByVal oEx As cOrbException, ByVal oIn As cOrbStream)
    Select Case lTypeCode
    Case tk_null
    Case tk_long
        lVal = oIn.read_long(oEx)
    Case tk_objref
        Set oVal = oIn.read_ObjRef(oEx)
    Case tk_struct
        For lVal = LBound(sMemberNames) To UBound(sMemberNames)
            Call aMemberVals(lVal).readValue(oEx, oIn)
            If oEx.isSet Then
                GoTo ExHandler
            End If
        Next lVal
    Case tk_string
        sVal = oIn.read_string(oEx)
    Case Else
        Call oEx.setMe("Any value " & lTypeCode & " is unsupported")
    End Select
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readValue: ")
End Sub

'Helper
Public Sub writeMe(ByVal oEx As cOrbException, ByVal oOut As cOrbStream)
    Call writeType(oEx, oOut)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call writeValue(oEx, oOut)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeAny: ")
End Sub

'Helper
Public Sub writeType(ByVal oEx As cOrbException, ByVal oOut As cOrbStream)
    Call oOut.write_long(oEx, lTypeCode)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Select Case lTypeCode
    Case tk_null To tk_Principal, tk_longlong To tk_wchar
    Case tk_objref
        Call oOut.writeEncapOpen(oEx, False) ' complex type
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oOut.write_string(oEx, sTypeId)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oOut.write_string(oEx, sTypeName)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oOut.writeEncapClose(oEx)
    Case tk_struct
        Call oOut.writeEncapOpen(oEx, False) ' complex type
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oOut.write_string(oEx, sTypeId)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oOut.write_string(oEx, sTypeName)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oOut.write_ulong(oEx, UBound(sMemberNames) - LBound(sMemberNames) + 1)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        For lVal = LBound(sMemberNames) To UBound(sMemberNames)
            Call oOut.write_string(oEx, sMemberNames(lVal))
            If oEx.isSet Then
                GoTo ExHandler
            End If
            Call aMemberVals(lVal).writeType(oEx, oOut)
            If oEx.isSet Then
                GoTo ExHandler
            End If
        Next lVal
        Call oOut.writeEncapClose(oEx)
    Case tk_string
        Call oOut.write_ulong(oEx, 0) 'max length
    Case Else
        Call oEx.setMe("Any type " & lTypeCode & " is unsupported")
    End Select
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeType: ")
End Sub

'Helper
Public Sub writeValue(ByVal oEx As cOrbException, ByVal oOut As cOrbStream)
    Select Case lTypeCode
    Case tk_null
    Case tk_long
        Call oOut.write_long(oEx, lVal)
    Case tk_objref
        Call oOut.write_ObjRef(oEx, oVal)
    Case tk_struct
        For lVal = LBound(sMemberNames) To UBound(sMemberNames)
            Call aMemberVals(lVal).writeValue(oEx, oOut)
            If oEx.isSet Then
                GoTo ExHandler
            End If
        Next lVal
    Case tk_string
        Call oOut.write_string(oEx, sVal)
    Case Else
        Call oEx.setMe("Any value " & lTypeCode & " is unsupported")
    End Select
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeValue: ")
End Sub

