VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbImpl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Copyright (c) 1999 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.

Option Explicit

Private Type tHostConn 'cOrbStream
    sHostPort As String
    iGetCnt As Integer
    oSock As cOrbSocket
    lTime As Long
End Type
Private conCnt As Long
Private oHostConns() As tHostConn
Private lReqId As Long

'Structure used in select() call
'struct timeval {
'    long    tv_sec;         /* seconds */
'    long    tv_usec;        /* and microseconds */
'};
Private Type tTimeVal
    tv_sec As Long
    tv_usec As Long
End Type

'int PASCAL FAR select (int nfds, fd_set FAR *readfds, fd_set FAR *writefds,
'   fd_set FAR *exceptfds, const struct timeval FAR *timeout);
Private Declare Function dllSelect Lib "Ws2_32.dll" Alias "select" _
    (ByVal nfds As Long, ByRef readFDs As Any, ByRef writeFDs As Any, _
    ByRef exceptFDs As Any, ByRef timeOut As tTimeVal) As Long

Private sLogFile As String
Private Type tServConn
    oSock As cOrbSocket
    lTime As Long
End Type
Private iTOCnt As Integer
Private oServConns() As tServConn
Private lSelFDs() As Long
Private sImplHost As String
Private sImplPort As String
Private collImpls As New Collection
Private bEndRunLoop As Boolean

'GetTickCount();
Private Declare Function GetTickCount Lib "kernel32" () As Long

'GetSystemTime();
Private Declare Sub GetSystemTime Lib "kernel32" _
    (lpSystemTime As SYSTEMTIME)
Private Type SYSTEMTIME
    wYear As Integer
    wMonth As Integer
    wDayOfWeek As Integer
    wDay As Integer
    wHour As Integer
    wMinute As Integer
    wSecond As Integer
    wMilliseconds As Integer
End Type

Private Sub Class_Initialize()
    ReDim oHostConns(0 To 2) As tHostConn
    conCnt = 0
    lReqId = 0
    ReDim oServConns(0 To 0) As tServConn
    ReDim lSelFDs(0 To 5) As Long
End Sub

Private Sub Class_Terminate()
    Erase oServConns
    Erase oHostConns
    conCnt = 0 'Otherwise ungetSocket() failed
End Sub

Public Function getNextReqId() As Long
    lReqId = lReqId + 1
    getNextReqId = lReqId
End Function

Public Function string_to_object(ByVal oEx As cOrbException, sURL As String) _
    As cOrbObjRef
    'Assert that init was successfully called
    If oServConns(0).oSock Is Nothing Then
        Dim oSystemEx As New cOrbSystemException
        Call oSystemEx.setINITIALIZE(1, oSystemEx.CompletedNO)
        Call oEx.setMe(oSystemEx.Description, Kind:=oSystemEx)
        GoTo ExHandler
    End If
    If InStr(sURL, "IOR:") = 1 Then
        Set string_to_object = iorstr_to_object(oEx, sURL)
    ElseIf InStr(sURL, "file://") = 1 Then
        Set string_to_object = file_to_object(oEx, sURL)
    ElseIf InStr(sURL, "http://") = 1 Then
        Set string_to_object = http_to_object(oEx, sURL)
    ElseIf InStr(sURL, "iioploc://") = 1 Then
        Set string_to_object = New cOrbObjRef
        Call string_to_object.readiioploc(oEx, Me, Mid$(sURL, 11))
    ElseIf InStr(sURL, "iiopname://") = 1 Then
        Set string_to_object = iiopname_to_object(oEx, sURL)
    Else
        Call oEx.setMe("Invalid URL: " & sURL)
    End If
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ExHandler:
    Call oEx.addPrefix("string_to_object: ")
    Set string_to_object = Nothing
End Function

Private Function file_to_object(ByVal oEx As cOrbException, ByVal sURL As String) _
    As cOrbObjRef
On Error GoTo ErrHandler
    Dim sFileName As String
    Dim iFileNo As Integer
    Dim sLine As String
   
    If Left$(sURL, 7) <> "file://" Then
        Call oEx.setMe("Invalid file-URL: " & sURL)
        GoTo ExHandler
    End If
    
    sFileName = Mid$(sURL, 8)
    iFileNo = FreeFile
    Open sFileName For Input As #iFileNo
    If Not EOF(iFileNo) Then
        Line Input #iFileNo, sLine
    End If
    Close #iFileNo
    
    Dim pos As Long
    pos = InStr(sLine, "IOR:")
    If pos = 0 Then
        Call oEx.setMe("File doesn't contain an IOR. " & sURL)
        GoTo ExHandler
    End If
    Set file_to_object = iorstr_to_object(oEx, Mid$(sLine, pos))
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("file_to_object: ")
    Set file_to_object = Nothing
End Function

Private Function http_to_object(ByVal oEx As cOrbException, ByVal sURL As String) _
    As cOrbObjRef
On Error GoTo ErrHandler
    Dim pos As Long
    Dim sHostPort As String
    Dim sPath As String
    
    If Left$(sURL, 7) <> "http://" Then
        Call oEx.setMe("Invalid http-URL: " & sURL)
        GoTo ExHandler
    End If
    
    pos = InStr(8, sURL & "/", "/")
    sHostPort = Mid$(sURL, 8, pos - 8)
    sPath = Mid$(sURL, pos)
    
    Dim oSock As New cOrbSocket
    Call oSock.initConnect(oEx, sHostPort, "80")
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call oSock.sendString(oEx, "GET " & sPath & " HTTP/1.0" & vbCrLf & vbCrLf _
        & "User-Agent: VB-IIOP VisualBasic 24-08-1999" & vbCrLf & vbCrLf _
        & "Accept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" & vbCrLf & vbCrLf _
        & "Connection: keep -alive" & vbCrLf & vbCrLf & vbCrLf & vbCrLf)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    Dim webpage As String
    webpage = oSock.recvString(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call oSock.termConnect(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    pos = InStr(webpage, "IOR:")
    If pos = 0 Then
        Call oEx.setMe("Webpage doesn't contain an IOR. " & sURL)
        GoTo ExHandler
    End If
    Set http_to_object = iorstr_to_object(oEx, Mid$(webpage, pos))
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("http_to_object: ")
    Set http_to_object = Nothing
End Function

Private Function iorstr_to_object(ByVal oEx As cOrbException, ByRef sIOR As String) _
    As cOrbObjRef
    If Left$(sIOR, 4) <> "IOR:" Then
        Call oEx.setMe("Invalid IOR format: " & Left$(sIOR, 8) & "...")
        GoTo ExHandler
    End If
    
    Dim oIn As New cOrbStream
    Call oIn.initBuffer((Len(sIOR) - 3) \ 2, Me)
    Call oIn.recvFromIOR(sIOR)
    Call oIn.readEncapOpen(oEx, (Len(sIOR) - 3) \ 2)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Set iorstr_to_object = oIn.read_ObjRef(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call oIn.readEncapClose(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ExHandler:
    Call oEx.addPrefix("iorstr_to_object: ")
    Set iorstr_to_object = Nothing
End Function

Public Function object_to_string(ByVal oEx As cOrbException, _
    ByVal oObjRef As cOrbObjRef) As String
    
    Dim oOut As New cOrbStream
    
    'GIOP Message Header
    Call oOut.initBuffer(1024, Me)
    
    'Like oOut.writeEncapOpen() without len
    Call oOut.write_boolean(oEx, oOut.littleEndian)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call oOut.write_ObjRef(oEx, oObjRef)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    Call oOut.sendToIOR(oEx, object_to_string)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ExHandler:
    Call oEx.addPrefix("object_to_string: ")
End Function

Private Function iiopname_to_object(ByVal oEx As cOrbException, ByRef sURL As String) _
    As cOrbObjRef
    Dim pos As Long
    Dim sHostPort As String
    Dim sPath As String
    
    If Left$(sURL, 7) <> "iiop://" Then
        Call oEx.setMe("Invalid iiop-URL: " & sURL)
        GoTo ExHandler
    End If
    
    pos = InStr(8, sURL & "/", "/")
    sHostPort = Mid$(sURL, 8, pos - 8)
    sPath = Mid$(sURL, pos)
    
    Set iiopname_to_object = New cOrbObjRef
    Call iiopname_to_object.readiioploc(oEx, Me, sHostPort)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ExHandler:
    Call oEx.addPrefix("iiopname_to_object: ")
    Set iiopname_to_object = Nothing
End Function

'by Craig Neuwirt
Public Function resolve_initial_references(ByVal oEx As cOrbException, _
    ByVal id As String) As cOrbObjRef
#If SERVICERESOLVER Then
    Set resolve_initial_references = oServiceResolver.f_get(oEx, id)
#End If
End Function

'by Craig Neuwirt
#If SERVICERESOLVER Then
Public Function list_initial_services(ByVal oEx As cOrbException _
    ) As c_SeqString
    Set list_initial_services = oServiceResolver.List(oEx)
End Function
#End If

Public Function getSocket(ByVal oEx As cOrbException, _
    ByRef sHostPort As String, ByVal bNew As Boolean) As cOrbSocket
    
    Dim lTime As Long
    lTime = GetTickCount() 'or getTime()
    Dim i1 As Long
    For i1 = 0 To conCnt - 1
        If oHostConns(i1).sHostPort = sHostPort Then
            If oHostConns(i1).iGetCnt = 0 _
                Or getLongDiff(oHostConns(i1).lTime, lTime) > 20000& _
                Or oHostConns(i1).oSock Is Nothing Then
                Set oHostConns(i1).oSock = New cOrbSocket
                Call oHostConns(i1).oSock.initConnect(oEx, sHostPort, "900")
                If oEx.isSet Then
                    GoTo ExHandler
                End If
            End If
            oHostConns(i1).lTime = lTime
            If bNew Then
                oHostConns(i1).iGetCnt = oHostConns(i1).iGetCnt + 1
            End If
            Set getSocket = oHostConns(i1).oSock
            Exit Function
        End If
    Next i1
    If conCnt > UBound(oHostConns) Then
        ReDim Preserve oHostConns(0 To conCnt + 2) As tHostConn
    End If
    oHostConns(conCnt).sHostPort = sHostPort
    Set oHostConns(conCnt).oSock = New cOrbSocket
    Call oHostConns(conCnt).oSock.initConnect(oEx, sHostPort, "900")
    If oEx.isSet Then
        GoTo ExHandler
    End If
    oHostConns(conCnt).lTime = lTime
    If bNew Then
        oHostConns(conCnt).iGetCnt = oHostConns(conCnt).iGetCnt + 1
    End If
    Set getSocket = oHostConns(conCnt).oSock
    conCnt = conCnt + 1
    Exit Function
ExHandler:
    Call oEx.addPrefix("getSocket: ")
    'Set getSocket = Nothing
End Function

Public Sub ungetSocket(ByRef sHostPort As String, ByVal connErr As Boolean)
    Dim i1 As Long
    For i1 = 0 To conCnt - 1
        If oHostConns(i1).sHostPort = sHostPort Then
            oHostConns(i1).iGetCnt = oHostConns(i1).iGetCnt - 1
            If oHostConns(i1).iGetCnt = 0 Or connErr Then
                Set oHostConns(i1).oSock = Nothing
            End If
            Exit For
        End If
    Next i1
End Sub

Private Function getLongDiff(ByVal l1 As Long, ByVal l2 As Long) As Long
    getLongDiff = IIf(l1 > l2, l1 - l2, l2 - l1)
End Function

Private Function getTime() As Long
    Dim lpSystemTime As SYSTEMTIME
    Call GetSystemTime(lpSystemTime) 'is about 50 times faster than "Now"
    getTime = lpSystemTime.wMonth * 31 + lpSystemTime.wDay
    getTime = getTime * 24 + lpSystemTime.wHour
    getTime = getTime * 60 + lpSystemTime.wMinute
    getTime = getTime * 60 + lpSystemTime.wSecond
End Function

Public Property Get localHost() As String
    localHost = sImplHost
End Property

Public Sub init(ByVal oEx As cOrbException, _
    Optional ByVal ImplPort As String = "0", _
    Optional ByVal sInitRefURL As String = "iioploc://localhost:900")
    'Get real name of localhost
    Set oServConns(0).oSock = New cOrbSocket
    sImplHost = oServConns(0).oSock.getHostName(oEx, True)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    'Bind the server socket immediately to retrieve the actual port
    Call oServConns(0).oSock.initBind(oEx, ImplPort)
    If oEx.isSet Then
        If oEx.Number = 10048 Then 'WSAEADDRINUSE
            'Maybe WSA was not terminated last time
            Call oServConns(0).oSock.initTermAll(True)
        End If
        GoTo ExHandler
    End If
    sImplPort = oServConns(0).oSock.socketPort
    
#If SERVICERESOLVER Then
    'Initialize the initial references resolver, by Craig Neuwirt
    If (Not sInitRefURL = "") Then
        Dim oObj As cOrbObjRef
        Set oObj = Me.string_to_object(oEx, sInitRefURL)
        If (Not oEx.isSet) Then
            Dim oInitRefAgent As New c_IOPInitialReferences
            Call oInitRefAgent.narrow(oEx, oObj)
            Call oServiceResolver.Initialize(Me, oInitRefAgent)
        End If
    Else
        Call oServiceResolver.Initialize(Me)
    End If
    If oEx.isSet Then
        GoTo ExHandler
    End If
#End If
    Exit Sub
ExHandler:
    Set oServConns(0).oSock = Nothing
    Call oEx.addPrefix("initOrb: ")
End Sub

Public Sub connect(ByVal oEx As cOrbException, ByVal newImpl As cOrbSkeleton, _
    Optional ByVal sKey As String = "")
    On Error GoTo ErrHandler
    If sKey = "" Then
        sKey = collImpls.Count & "_" & GetTickCount()
    End If
    Dim oObjRef As New cOrbObjRef
    '"1.1@host:portno/key"
    Call oObjRef.readiioploc(oEx, Me, "1.1@" & sImplHost & ":" & _
        sImplPort & "/" & sKey)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call oObjRef.testId(oEx, newImpl.TypeId)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Set newImpl.ObjRef = oObjRef
    Call collImpls.Add(newImpl, sKey)
    Exit Sub
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("connectToOrb: ")
End Sub

Public Sub disconnect(ByVal oEx As cOrbException, ByVal oldImpl As cOrbSkeleton)
    On Error GoTo ErrHandler
    Dim oObjRef As cOrbObjRef
    Dim sKey As String
    Dim oImpl As cOrbSkeleton
    Dim oSystemEx As cOrbSystemException
    Set oObjRef = oldImpl.ObjRef
    If oObjRef Is Nothing Then
        GoTo ExINVOBJREF
    End If
    sKey = oObjRef.objectKey
    On Error GoTo SearchErr
    Set oImpl = collImpls.Item(sKey)
SearchResume:
    On Error GoTo ErrHandler
    If oImpl Is Nothing Then
        GoTo ExINVOBJREF
    End If
    Call collImpls.Remove(sKey)
    Call oObjRef.releaseMe
    Set oldImpl.ObjRef = Nothing
    Exit Sub
SearchErr:
    Set oImpl = Nothing
    GoTo SearchResume
ExINVOBJREF:
    Set oSystemEx = New cOrbSystemException
    Call oSystemEx.setINVOBJREF(1, oSystemEx.CompletedNO)
    Call oEx.setMe(oSystemEx.Description, Kind:=oSystemEx)
    GoTo ExHandler
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("disconnect: ")
End Sub

'Run or prepare the server
Public Sub run(ByVal oEx As cOrbException, _
    Optional ByVal bLoop As Boolean = True, _
    Optional ByVal LogFile As String = "")
    On Error GoTo ErrHandler
    sLogFile = LogFile
    'Assert that init was successfully called
    If oServConns(0).oSock Is Nothing Then
        Dim oSystemEx As New cOrbSystemException
        Call oSystemEx.setINITIALIZE(1, oSystemEx.CompletedNO)
        Call oEx.setMe(oSystemEx.Description, Kind:=oSystemEx)
        GoTo ExHandler
    End If
    Call oServConns(0).oSock.startListen(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call messageLog("Server is listening on port " _
        & sImplPort & " at " & sImplHost)
    If Not bLoop Then
        Exit Sub
    End If
    
    bEndRunLoop = False
    Do
        DoEvents 'Prevent blocking other processes
        Call work(oEx, 10)
        If oEx.isSet Then GoTo ExHandler
    Loop Until bEndRunLoop
    Exit Sub
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("runOrb: ")
End Sub

Public Sub shutdown(Optional ByVal sWait As Boolean = True)
    bEndRunLoop = True
End Sub

Public Sub exceptionLog(ByVal oEx As cOrbException)
    Call messageLog("Exception: " & oEx.Number & ", " & oEx.Description)
    Call oEx.unSet
End Sub

Public Sub messageLog(ByVal sMessage As String)
    If Len(sLogFile) = 0 Then
        Exit Sub
    End If
    Dim iFileNo As Integer
    iFileNo = FreeFile
    Open sLogFile For Append As #iFileNo
    Dim lpSystemTime As SYSTEMTIME
    Call GetSystemTime(lpSystemTime) 'is about 50 times faster than "Now"
    Print #iFileNo, lpSystemTime.wYear & "." & lpSystemTime.wMonth & "." _
        & lpSystemTime.wDay & "-" & lpSystemTime.wHour & ":" _
        & lpSystemTime.wMinute & ":" & lpSystemTime.wSecond & " " & sMessage
    Close #iFileNo
End Sub

'Called by run() with lWaitTime > 0 or called by a Timer with lWaitTime = 0
Public Sub work(ByVal oEx As cOrbException, ByVal lWaitTime As Long)
    'Assert that init was successfully called
    If oServConns(0).oSock Is Nothing Then
        Dim oSystemEx As New cOrbSystemException
        Call oSystemEx.setINITIALIZE(1, oSystemEx.CompletedNO)
        Call oEx.setMe(oSystemEx.Description, Kind:=oSystemEx)
        GoTo ExHandler
    End If
    Dim slotLen As Long
    Dim slotCnt As Long
    Dim sockCnt As Long
    sockCnt = 0
    slotLen = UBound(oServConns) + 1
    For slotCnt = 0 To UBound(oServConns)
        If Not oServConns(slotCnt).oSock Is Nothing Then
            sockCnt = sockCnt + 1
            lSelFDs(sockCnt) = oServConns(slotCnt).oSock.socketFd
        End If
    Next slotCnt
    lSelFDs(0) = sockCnt 'readFDs.fd_count
    lSelFDs(slotLen + 1) = 0 'writeFDs.fd_count
    lSelFDs(slotLen * 2 + 2) = 0 'exceptFDs.fd_count
    
    Dim timeOut As tTimeVal
    timeOut.tv_usec = (lWaitTime Mod 1000) * 1000
    timeOut.tv_sec = lWaitTime \ 1000
    'Check incoming ClientSockets, Possible to accept/read data or timeout?
    If dllSelect(slotLen, lSelFDs(0), lSelFDs(slotLen + 1), _
        lSelFDs(slotLen * 2 + 2), timeOut) = -1 Then
        Call oEx.setMe("select() failed", Err.LastDllError)
        GoTo ExHandler
    End If
    Dim lTime As Long
    lTime = GetTickCount()
    Dim recvAgain As Boolean
    Dim oOut As cOrbStream
    For slotCnt = 1 To UBound(oServConns)
        If oServConns(slotCnt).oSock Is Nothing Then
            GoTo nextSocket
        End If
        'Possible to read data or timeout?
        recvAgain = False
        For sockCnt = 1 To lSelFDs(0)
            If oServConns(slotCnt).oSock.socketFd = lSelFDs(sockCnt) Then
                recvAgain = True
                Exit For
            End If
        Next sockCnt
        If Not recvAgain Then
            'TimeOut, Close served socked if longer than 60s unused
            If iTOCnt = 0 Then
                If getLongDiff(oServConns(slotCnt).lTime, lTime) > 60000 Then
                    GoTo closeSocket
                End If
            End If
            GoTo nextSocket
        End If
        oServConns(slotCnt).lTime = lTime
        Dim recvLen As Long
        recvLen = oServConns(slotCnt).oSock.recvCurrentLen(oEx)
        If oEx.isSet Then
            Call exceptionLog(oEx) 'Also calling oEx.unSet()
            GoTo termSocket
        End If
        If recvLen = 0 Then
            GoTo termSocket
        End If
        Dim oIn As New cOrbStream
        Call oIn.initBuffer(1024, Me)
        Dim msgType As Byte
        'Receive GIOP Message Header
        msgType = oIn.recvGIOPFromSocket(oEx, oServConns(slotCnt).oSock)
        If oEx.isSet Then
            Call exceptionLog(oEx) 'Also calling oEx.unSet()
            GoTo termSocket
        End If
        Set oOut = New cOrbStream
        Select Case msgType
        Case 0 '= GIOP Request
            Call replyRequest(oEx, oIn, oOut)
            If Not oEx.isSet And Not oOut Is Nothing Then
                '1 = Reply
                Call oOut.sendGIOPToSocket(oEx, 1, oServConns(slotCnt).oSock)
            End If
        Case 3 '= Locate Request
            Call replyLocateRequest(oEx, oIn, oOut)
            If Not oEx.isSet And Not oOut Is Nothing Then
                '4 = LocateReply
                Call oOut.sendGIOPToSocket(oEx, 4, oServConns(slotCnt).oSock)
            End If
        Case Else
            Call oEx.setMe("Unknown GIOP msgType: " & msgType)
        End Select
        If oEx.isSet Then
            Call exceptionLog(oEx) 'Also calling oEx.unSet()
            GoTo termSocket
        End If
        GoTo nextSocket
closeSocket:
        '5 = CloseConnection
        Set oOut = New cOrbStream
        'Prepare GIOP Message Header
        Call oOut.initGIOPOut(oEx, oIn.getGIOPVersion, Me)
        If oEx.isSet Then
            Call exceptionLog(oEx) 'Also calling oEx.unSet()
            GoTo termSocket
        End If
        Call oOut.sendGIOPToSocket(oEx, 5, oServConns(slotCnt).oSock)
        If oEx.isSet Then
            Call exceptionLog(oEx) 'Also calling oEx.unSet()
        End If
termSocket:
        Call oServConns(slotCnt).oSock.termAccept(oEx)
        If oEx.isSet Then
            Call exceptionLog(oEx) 'Also calling oEx.unSet()
        End If
        Set oServConns(slotCnt).oSock = Nothing
nextSocket:
    Next slotCnt
    'Possible to accept or timeout?
    recvAgain = False
    For sockCnt = 1 To lSelFDs(0)
        If oServConns(0).oSock.socketFd = lSelFDs(sockCnt) Then
            recvAgain = True
            Exit For
        End If
    Next sockCnt
    If recvAgain Then
        'Find a free slot
        For slotCnt = 1 To UBound(oServConns)
            If oServConns(slotCnt).oSock Is Nothing Then
                Exit For
            End If
        Next slotCnt
        If slotCnt > UBound(oServConns) Then
            ReDim Preserve oServConns(0 To slotCnt + 2) As tServConn
            ReDim lSelFDs(0 To (slotCnt + 2) * 3 + 5)
        End If
        
        Set oServConns(slotCnt).oSock = New cOrbSocket
        oServConns(slotCnt).lTime = lTime
        Call oServConns(slotCnt).oSock.initAccept(oEx, oServConns(0).oSock)
        If oEx.isSet Then GoTo ExHandler
        Call messageLog("Accepting new connection from: " & _
            oServConns(slotCnt).oSock.socketHost & ":" & _
            oServConns(slotCnt).oSock.socketPort)
    End If
    'TimeOut, Close connections to hosts if longer than 40s unused
    If iTOCnt = 0 Then
        For slotCnt = 0 To conCnt - 1
            If oHostConns(slotCnt).iGetCnt > 0 And _
                Not oHostConns(slotCnt).oSock Is Nothing And _
                getLongDiff(oHostConns(slotCnt).lTime, lTime) > 40000 Then
                Call oHostConns(slotCnt).oSock.termConnect(oEx)
                If oEx.isSet Then
                    Call exceptionLog(oEx) 'Also calling oEx.unSet()
                End If
                Set oHostConns(slotCnt).oSock = Nothing
            End If
        Next slotCnt
    End If
    iTOCnt = iTOCnt + 1
    If iTOCnt > 10 Then iTOCnt = 0
    Exit Sub
ExHandler:
    Call oEx.addPrefix("work: ")
End Sub

'Execute a Client Request
Private Sub replyRequest(ByVal oEx As cOrbException, _
    ByVal oIn As cOrbStream, ByRef oOut As cOrbStream)
    On Error GoTo ErrHandler
    'Read GIOP Request Header
    Dim seqSC, i1 As Long
    Dim baObjKey() As Byte
    Dim sOperation As String
    
    If oIn.getGIOPVersion <> "1.2" Then
        'IOP::ServiceContextList service_context;
        seqSC = oIn.read_ulong(oEx)
        If oEx.isSet Then GoTo ExHandler
        For i1 = 1 To seqSC
            Call oIn.read_ulong(oEx)
            If oEx.isSet Then GoTo ExHandler
            Call oIn.readSkip(oEx, oIn.read_ulong(oEx))
            If oEx.isSet Then GoTo ExHandler
        Next i1
    End If
    'request_id;
    Dim reqId As Long
    reqId = oIn.read_ulong(oEx)
    If oEx.isSet Then GoTo ExHandler
    'response_expected;
    Dim responseExpected As Boolean 'non oneway
    responseExpected = oIn.read_boolean(oEx)
    If oEx.isSet Then GoTo ExHandler
    
    Dim oSystemEx As cOrbSystemException 'after responseExpected
    If oIn.getGIOPVersion <> "1.0" Then
        'octet reserved[3];
        Call oIn.read_octet(oEx)
        If oEx.isSet Then GoTo ExHandler
        Call oIn.read_octet(oEx)
        If oEx.isSet Then GoTo ExHandler
        Call oIn.read_octet(oEx)
        If oEx.isSet Then GoTo ExHandler
    End If
    If oIn.getGIOPVersion <> "1.2" Then
        'sequence <octet> object_key;
        Call oIn.readSeqOctet(oEx, baObjKey)
        If oEx.isSet Then GoTo ExHandler
        'operation;
        sOperation = oIn.read_string(oEx)
        If oEx.isSet Then GoTo ExHandler
        'Principal (not in GIOP 1.2)
        Dim pcpLen As Long
        pcpLen = oIn.read_ulong(oEx)
        If oEx.isSet Then GoTo ExHandler
        Call oIn.readSkip(oEx, pcpLen)
        If oEx.isSet Then GoTo ExHandler
    Else
        'TargetAddress target;
        Dim addrDisposition As Integer
        addrDisposition = oIn.read_short(oEx)
        If oEx.isSet Then GoTo ExHandler
        If addrDisposition <> 0 Then    '0 = KeyAddr
            Call oEx.setMe("Unknown AddressingDisposition: " & addrDisposition)
            GoTo ExHandler
        End If
        Call oIn.readSeqOctet(oEx, baObjKey)
        If oEx.isSet Then GoTo ExHandler
        'operation;
        sOperation = oIn.read_string(oEx)
        If oEx.isSet Then GoTo ExHandler
        'IOP::ServiceContextList service_context;
        seqSC = oIn.read_ulong(oEx)
        If oEx.isSet Then GoTo ExHandler
        For i1 = 1 To seqSC
            Call oIn.read_ulong(oEx)
            If oEx.isSet Then GoTo ExHandler
            Call oIn.readSkip(oEx, oIn.read_ulong(oEx))
            If oEx.isSet Then GoTo ExHandler
        Next i1
    End If

    'Prepare GIOP Message Header
    'Discard oOut later if oneway
    Call oOut.initGIOPOut(oEx, oIn.getGIOPVersion, Me)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    'Write GIOP Reply Header
    Dim repStatusPos As Long
    repStatusPos = writeReplyHeader(oEx, oOut, reqId, 0) '0 = NO_EXCEPTION
    If oEx.isSet Then
        GoTo ExHandler
    End If

    'Call messageLog("Request operation: " & sOperation)
    Dim oImpl As cOrbSkeleton
    Dim sKey As String
    sKey = objKey2String(baObjKey)
    On Error GoTo SearchErr
    Set oImpl = collImpls.Item(sKey)
SearchResume:
    On Error GoTo ErrHandler
    'Read Request, write Reply
    'boolean _non_existent()???
    'boolean _is_a()???
    'InterfaceDef _interface()???
    If oImpl Is Nothing Then
        Call messageLog("Object key '" & sKey _
            & "' not found to execute '" & sOperation & "()'")
        Set oSystemEx = New cOrbSystemException
        Call oSystemEx.setINVOBJREF(1, oSystemEx.CompletedNO)
        GoTo SendSystemEx
    End If
    'Execute request: sKey.sOperation()
    Dim repStatus As Long
    repStatus = oImpl.execute(oEx, sOperation, oIn, oOut)
    If oEx.isSet Then
        If TypeName(oEx.Kind) = "cOrbSystemException" Then
            Set oSystemEx = oEx.Kind
        Else
            Set oSystemEx = New cOrbSystemException
            Call oSystemEx.setUNKNOWN(1, oSystemEx.CompletedMAYBE)
        End If
        Call exceptionLog(oEx) 'Also calling oEx.unSet()
        GoTo SendSystemEx
    End If
    If responseExpected Then 'non oneway
        'send UserException?
        If repStatus <> 0 Then
            Call oOut.setPos(oEx, repStatusPos)
            If oEx.isSet Then
                GoTo ExHandler
            End If
            'ReplyStatusType reply_status;
            Call oOut.write_ulong(oEx, repStatus)
            If oEx.isSet Then
                GoTo ExHandler
            End If
        End If
    Else
        Set oOut = Nothing
    End If
    Exit Sub
SendSystemEx:
    If responseExpected Then 'non oneway
        'Init oOut again
        Call oOut.initGIOPOut(oEx, oIn.getGIOPVersion, Me)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'Write GIOP Reply Header
        Call writeReplyHeader(oEx, oOut, reqId, 2) '2 = SYSTEM_EXCEPTION
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oSystemEx.writeMe(oEx, oOut)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    Else
        Set oOut = Nothing
        Call oEx.setMe(oSystemEx.Description, Kind:=oSystemEx)
        GoTo ExHandler
    End If
    Exit Sub
SearchErr:
    Set oImpl = Nothing
    GoTo SearchResume
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("replyRequest: ")
End Sub

Private Function writeReplyHeader(ByVal oEx As cOrbException, _
    ByVal oOut As cOrbStream, ByVal reqId As Long, ByVal repStatus As Long) As Long
    On Error GoTo ErrHandler
    If oOut.getGIOPVersion <> "1.2" Then
        'IOP::ServiceContextList service_context;
        Call oOut.write_ulong(oEx, 0)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'unsigned long request_id;
        Call oOut.write_ulong(oEx, reqId)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'ReplyStatusType reply_status;
        writeReplyHeader = oOut.getPos
        Call oOut.write_ulong(oEx, repStatus) '0 = NO_EXCEPTION
        If oEx.isSet Then
            GoTo ExHandler
        End If
    Else
        'unsigned long request_id;
        Call oOut.write_ulong(oEx, reqId)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'ReplyStatusType reply_status;
        writeReplyHeader = oOut.getPos
        Call oOut.write_ulong(oEx, repStatus) '0 = NO_EXCEPTION
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'IOP::ServiceContextList service_context;
        Call oOut.write_ulong(oEx, 0)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    End If
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("writeReplyHeader: ")
End Function

'Written by Holger Beer
'Execute a Client Locate Request
Private Sub replyLocateRequest(ByVal oEx As cOrbException, _
    ByVal oIn As cOrbStream, ByRef oOut As cOrbStream)
    On Error GoTo ErrHandler
    'Read GIOP LocateRequest Header
    Dim reqId As Long, locStatus As Long
    Dim baObjKey() As Byte
    
    If oIn.getGIOPVersion <> "1.2" Then
        'IOP::ServiceContextList service_context;
        reqId = oIn.read_ulong(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oIn.readSeqOctet(oEx, baObjKey)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    End If
    
    '???
    '!! check if object is here, set locStatus
    locStatus = 1 '1 = OBJECT_HERE
    
    'Prepare GIOP Message Header
    Call oOut.initGIOPOut(oEx, oIn.getGIOPVersion, Me)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    'Write GIOP Reply Header
    Dim repStatusPos As Long
    Call writeLocateReplyHeader(oEx, oOut, reqId, locStatus) '1 = OBJECT_HERE
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("replyLocateRequest: ")
End Sub

'Written by Holger Beer
Private Sub writeLocateReplyHeader(ByVal oEx As cOrbException, _
    ByVal oOut As cOrbStream, ByVal reqId As Long, ByVal locStatus As Long)
    On Error GoTo ErrHandler
    If oOut.getGIOPVersion <> "1.2" Then
        'unsigned long request_id;
        Call oOut.write_ulong(oEx, reqId)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'LocateStatusType;
        Call oOut.write_ulong(oEx, locStatus)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    Else
        '???
      '!! write 1.2 LocateReply header
    End If
    Exit Sub
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("writeLocateReplyHeader: ")
End Sub

Public Function objKey2String(ByRef objKey() As Byte) As String
    objKey2String = ""
    Dim iKey As Integer
    For iKey = LBound(objKey) To UBound(objKey)
        If objKey(iKey) <= &HF Then
            objKey2String = objKey2String & "%0" & Hex$(objKey(iKey))
        ElseIf objKey(iKey) < 32 Or objKey(iKey) >= 128 _
            Or objKey(iKey) = Asc("%") Then
            objKey2String = objKey2String & "%" & Hex$(objKey(iKey))
        Else
            objKey2String = objKey2String & Chr$(objKey(iKey))
        End If
    Next iKey
End Function
