VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbObjRef"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Copyright (c) 1999 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.

Option Explicit

Private oOrb As cOrbImpl

'Interoperable Object Reference (IOR)
'An IOR is a sequence of object-specific protocol profiles, plus a type ID.

'------ TypeId -------
'TypeId example: IDL:foo/bar:1.0
Private sTypeId As String
'NullTypeID is a string which contains only a single terminating character.
'A NullTypeID is the only mechanism that can be used to represent the type
'CORBA::Object. TypeIDs may only be Null in any message, requiring the client
'to use existing knowledge or to consult the object, to determine interface
'types supported.
Const sNullTypeId As String = ""

'------ Profiles -------
'sequence <TaggedProfile> profiles;
Private TPLen As Long
Const TAG_INTERNET_IOP As Long = 0
Const TAG_MULTIPLE_COMPONENTS As Long = 1

'Components of TAG_INTERNET_IOP profile
Const TAG_ALTERNATE_IIOP_ADDRESS As Long = 3

'IIOP Version, example:  1.0
Private sIIOPVersion As String

'Object key, example:    0x3A 3A 00 0F 2E 48 22 3C 01 3C 1F
Private baObjKey() As Byte

'Number of addresses
Private iAddrCnt As Integer

'Host, example:       164.25.33.38
Private sHosts(4) As String

'Port, example:       3821
Private iPorts(4) As Integer

'Address index or 0
Private iAddrIdx As Integer

Private lastReqId As Long
Private lastResponseExpected As Boolean

Private Sub Class_Initialize()
    'Set oOrb = Nothing
    'sTypeId = sNullTypeId
    'TPLen = 0
    'iAddrCnt = 0
    'iAddrIdx = 0
End Sub

Private Sub Class_Terminate()
    If Not oOrb Is Nothing Then
        If iAddrIdx > 0 Then
            Call oOrb.ungetSocket(getHostPort(iAddrIdx - 1), False)
            iAddrIdx = 0
        End If
        Set oOrb = Nothing
    End If
End Sub

Public Sub releaseMe()
    Call Class_Terminate
    sTypeId = sNullTypeId
    TPLen = 0
    iAddrCnt = 0
End Sub

'Initialies me (ObjRef) by iioploc URL
'sURL= "1.1@host:portno/key"
Public Sub readiioploc(ByVal oEx As cOrbException, ByVal Orb As cOrbImpl, _
    ByVal sURL As String)
    On Error GoTo ErrHandler
    Set oOrb = Orb
    
    'string type_id;
    sTypeId = sNullTypeId

    Dim pos As Long
    Dim sAddrList As String
    Dim sObjKey As String
    pos = InStr(sURL & "/", "/")
    sAddrList = Left$(sURL, pos - 1)
    sObjKey = Mid$(sURL, pos + 1)
    
    '{octet major; octet minor} iiop_version;
    sIIOPVersion = "1.0"
    
    Dim sAddr As String
    Dim lNextPos As Long
    Do
        lNextPos = InStr(sAddrList, ",")
        If lNextPos = 0 Then
            sAddr = sAddrList
        Else
            sAddr = Left$(sAddrList, lNextPos - 1)
            sAddrList = Mid$(sAddrList, lNextPos + 1)
        End If
        
        '{octet major; octet minor} iiop_version;
        pos = InStr(sAddr, "@")
        If pos > 0 Then
            sIIOPVersion = Left$(sAddr, pos - 1)
            sAddr = Mid$(sAddr, pos + 1)
        End If
        
        'string host; unsigned short port;
        pos = InStr(sAddr, ":")
        If pos = 0 Then
            sHosts(iAddrCnt) = sAddr
            iPorts(iAddrCnt) = 9000
        Else
            sHosts(iAddrCnt) = Left$(sAddr, pos - 1)
            Dim lPort As Long
            On Error GoTo BadPort
            lPort = Mid$(sAddr, pos + 1)
            On Error GoTo ErrHandler
            If lPort < 0 Or lPort >= &H10000 Then
                Call oEx.setMe("Portnumber " & lPort & " is out of range")
                GoTo ExHandler
            End If
            iPorts(iAddrCnt) = IIf(lPort <= &H7FFF, lPort, lPort - &H10000)
        End If
        If sHosts(iAddrCnt) = "" Or sHosts(iAddrCnt) = "localhost" Then
            sHosts(iAddrCnt) = oOrb.localHost
        End If
        iAddrCnt = iAddrCnt + 1
    Loop Until lNextPos = 0
    
    If Len(sObjKey) > 0 Then
        'sequence <octet> object_key;
        'see objKey2String also
        Dim lKey As Long
        lKey = 0
        ReDim baObjKey(0 To Len(sObjKey) - 1)
        pos = 1
        Do
            If Mid$(sObjKey, pos, 1) = "%" Then
                baObjKey(lKey) = val("&H" & Mid$(sObjKey, pos + 1, 2))
                pos = pos + 3
            Else
                baObjKey(lKey) = Asc(Mid$(sObjKey, pos))
                pos = pos + 1
            End If
            lKey = lKey + 1
        Loop While pos <= Len(sObjKey)
        ReDim Preserve baObjKey(0 To lKey - 1)
    Else
        'UBound(baObjKey) = -1
        baObjKey = MidB(sObjKey, 1, 0)
    End If
    TPLen = 1
    Exit Sub
BadPort:
    Call oEx.setMe("Portnumber " & Mid$(sAddr, pos + 1) & " is invalid")
    GoTo ExHandler
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("readiioploc: ")
End Sub

'Initialies me (ObjRef) by IOR
'RET: True if reading a null object reference
Public Function readMe(ByVal oEx As cOrbException, ByVal Orb As cOrbImpl, _
    ByVal oIn As cOrbStream) As Boolean
    
    Set oOrb = Orb
    'string type_id;
    'Example: IDL:TArbIdl/TConnFactory:1.0
    sTypeId = oIn.read_string(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    'sequence <TaggedProfile> profiles;
    TPLen = oIn.read_ulong(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Dim iP As Integer
    For iP = 1 To TPLen
        'ProfileId tag
        Dim tagP As Long
        tagP = oIn.read_ulong(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'sequence <octet> profile_data
        Dim seqPD As Long
        seqPD = oIn.read_ulong(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        If tagP = TAG_INTERNET_IOP Then 'ProfileId
            Call oIn.readEncapOpen(oEx, seqPD)
            If oEx.isSet Then
                GoTo ExHandler
            End If
            '{octet major; octet minor} iiop_version;
            sIIOPVersion = oIn.read_octet(oEx) & "." _
                & oIn.read_octet(oEx)
            'string host; unsigned short port;
            sHosts(iAddrCnt) = oIn.read_string(oEx)
            iPorts(iAddrCnt) = oIn.read_ushort(oEx)
            iAddrCnt = iAddrCnt + 1
            'sequence <octet> object_key;
            Call oIn.readSeqOctet(oEx, baObjKey)
            If oEx.isSet Then
                GoTo ExHandler
            End If
            'Optional
            If sIIOPVersion = "1.1" Or sIIOPVersion = "1.2" Then
                'sequence <IOP::TaggedComponent> components;
                Dim iC As Long, TCLen As Long
                TCLen = oIn.read_ulong(oEx)
                If oEx.isSet Then
                    GoTo ExHandler
                End If
                For iC = 1 To TCLen
                    'ComponentId tag
                    Dim tagC As Long
                    tagC = oIn.read_ulong(oEx)
                    'sequence <octet> component_data;
                    Dim CDLen As Long
                    CDLen = oIn.read_ulong(oEx)
                    If tagC = TAG_ALTERNATE_IIOP_ADDRESS Then
                        Call oIn.readEncapOpen(oEx, CDLen)
                        If oEx.isSet Then
                            GoTo ExHandler
                        End If
                        'string HostID; short Port;
                        sHosts(iAddrCnt) = oIn.read_string(oEx)
                        iPorts(iAddrCnt) = oIn.read_short(oEx)
                        iAddrCnt = iAddrCnt + 1
                        Call oIn.readEncapClose(oEx)
                    Else
                        'Skipping unknown component tag
                        Call oIn.readSkip(oEx, CDLen)
                    End If
                Next iC
            End If
            Call oIn.readEncapClose(oEx)
            If oEx.isSet Then
                GoTo ExHandler
            End If
        Else
            'Skipping unknown profile tag
            Call oIn.readSkip(oEx, seqPD)
            If oEx.isSet Then
                GoTo ExHandler
            End If
        End If
    Next iP
    'Null object references are indicated by an empty set of profiles,
    'and by a NullTypeID
    If sTypeId = sNullTypeId And TPLen = 0 Then
        readMe = True
    End If
    Exit Function
ExHandler:
    Call oEx.addPrefix("readMe: ")
End Function

'Writing the IOR of me
Public Sub writeMe(ByVal oEx As cOrbException, ByVal oOut As cOrbStream)
    
    'Check to avoid difficult programming errors
    If sTypeId = sNullTypeId Then
        Call oEx.setMe("Object has no IDL type_id")
        GoTo ExHandler
    End If
    
    'string type_id; example: IDL:foo/bar:1.0
    Call oOut.write_string(oEx, sTypeId)
    If oEx.isSet Then
        GoTo ExHandler
    End If

    'sequence <TaggedProfile> profiles;
    TPLen = IIf(iAddrCnt > 0, 1, 0)
    Call oOut.write_ulong(oEx, TPLen)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Dim iP As Integer
    For iP = 1 To TPLen
        'ProfileId tag
        Dim tagP As Long
        'if iAddrCnt > 0
        tagP = TAG_INTERNET_IOP 'ProfileId
        Call oOut.write_ulong(oEx, tagP)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'sequence <octet> profile_data
        Call oOut.writeEncapOpen(oEx, False)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        '{octet major; octet minor} iiop_version;
        Call oOut.write_octet(oEx, CByte(Mid$(sIIOPVersion, 1, 1)))
        Call oOut.write_octet(oEx, CByte(Mid$(sIIOPVersion, 3, 1)))
        'string host; unsigned short port;
        Call oOut.write_string(oEx, sHosts(0))
        Call oOut.write_ushort(oEx, iPorts(0))
        'sequence <octet> object_key;
        Call oOut.writeSeqOctet(oEx, baObjKey, _
            UBound(baObjKey) - LBound(baObjKey) + 1)
        'Optional
        If sIIOPVersion = "1.1" Or sIIOPVersion = "1.2" Then
            'sequence <IOP::TaggedComponent> components;
            Dim iC As Long, TCLen As Long, iAddrIx As Long
            TCLen = iAddrCnt - 1
            iAddrIx = 1
            Call oOut.write_ulong(oEx, TCLen)
            For iC = 1 To TCLen
                'ComponentId tag
                Dim tagC As Long
                tagC = TAG_ALTERNATE_IIOP_ADDRESS
                Call oOut.write_ulong(oEx, tagC)
                'sequence <octet> component_data;
                Call oOut.writeEncapOpen(oEx, False)
                If oEx.isSet Then
                    GoTo ExHandler
                End If
                'string HostID; short Port;
                Call oOut.write_string(oEx, sHosts(iAddrIx))
                Call oOut.write_short(oEx, iPorts(iAddrIx))
                iAddrIx = iAddrIx + 1
                Call oOut.writeEncapClose(oEx)
            Next iC
        End If
        Call oOut.writeEncapClose(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    Next iP
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeMe: ")
End Sub

Public Property Get Orb() As cOrbImpl
    Set Orb = oOrb
End Property

Public Property Get objectKey() As String
    objectKey = oOrb.objKey2String(baObjKey)
End Property

Public Property Get TypeId() As String
    TypeId = sTypeId
End Property

Public Property Get IIOPAddress() As String
    Dim i1 As Integer
    i1 = 0
    IIOPAddress = IIf(iAddrCnt = 0, "", getHostPort(i1))
    Do
        i1 = i1 + 1
        If i1 >= iAddrCnt Then
            Exit Do
        End If
        IIOPAddress = IIOPAddress & "," & getHostPort(i1)
    Loop
End Property

Public Property Get IIOPVersion() As String
    IIOPVersion = sIIOPVersion
End Property

Private Function getHostPort(ByVal n As Integer) As String
    Dim lPort As Long
    lPort = iPorts(n)
    If lPort < 0 Then
        lPort = lPort + &H10000
    End If
    getHostPort = sHosts(n) & ":" & lPort
End Function

Public Function is_a(sRepId As String) As Boolean
    is_a = (sRepId = sTypeId)
End Function

Public Sub testId(ByVal oEx As cOrbException, sRepId As String)
    If Not is_a(sRepId) Then
        If Not is_a(sNullTypeId) Then
            Call oEx.setMe("testId: Object " & sTypeId & " is not equal " & sRepId)
        End If
        'remote call _is_a()???
        sTypeId = sRepId
    End If
End Sub

'see: org.omg.CORBA.portable.Delegate
Public Function request(ByVal oEx As cOrbException, sOperation As String, _
    ByVal bResponseExpected As Boolean) As cOrbStream
    
    Const sGIOPVersion As String = "1.0"
    Set request = New cOrbStream
    
    'Prepare GIOP Message Header
    Call request.initGIOPOut(oEx, sGIOPVersion, oOrb)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    'Write GIOP Request Header
    If request.getGIOPVersion <> "1.2" Then
        'IOP::ServiceContextList service_context;
        Call request.write_ulong(oEx, 0)
    End If
    'request_id; response_expected;
    lastReqId = oOrb.getNextReqId()
    Call request.write_ulong(oEx, lastReqId)
    lastResponseExpected = bResponseExpected
    Call request.write_boolean(oEx, bResponseExpected)
    If request.getGIOPVersion <> "1.0" Then
        'octet reserved[3];
        Call request.write_octet(oEx, 0)
        Call request.write_octet(oEx, 0)
        Call request.write_octet(oEx, 0)
    End If
    If request.getGIOPVersion <> "1.2" Then
        'sequence <octet> object_key;
        Call request.writeSeqOctet(oEx, baObjKey, UBound(baObjKey) + 1)
        'operation;
        Call request.write_string(oEx, sOperation)
        'Principal (not in GIOP 1.2)
        Call request.write_ulong(oEx, 0)
    Else
        'TargetAddress target;
        Call request.write_short(oEx, 0)
        Call request.writeSeqOctet(oEx, baObjKey, UBound(baObjKey) + 1)
        'operation;
        Call request.write_string(oEx, sOperation)
        'IOP::ServiceContextList service_context;
        Call request.write_ulong(oEx, 0)
    End If
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ExHandler:
    Call oEx.addPrefix("request: ")
End Function

'see: org.omg.CORBA.portable.Delegate
'The method name "invoke" is not allowed in VB
' RET:  oIn or Nothing
Public Function invokeReq(ByVal oEx As cOrbException, _
    ByVal oOut As cOrbStream) As cOrbStream
On Error GoTo ErrHandler
    Dim recvAgain As Boolean
    recvAgain = False
tryAgain:
    Dim oSock As cOrbSocket
    Set oSock = Nothing
    If iAddrIdx > 0 Then
        Set oSock = oOrb.getSocket(oEx, getHostPort(iAddrIdx - 1), False)
        If oEx.isSet Then
            If iAddrCnt <= 1 Then
                GoTo ExHandler
            End If
            Call oEx.unSet
            Call oOrb.ungetSocket(getHostPort(iAddrIdx - 1), False)
            iAddrIdx = 0
        End If
    End If
    If oSock Is Nothing Then
        If iAddrCnt = 0 Then
            Call oEx.setMe("IIOP address is missing.")
            GoTo ExHandler
        End If
        Dim i2 As Integer
        i2 = 0
        Do
            Set oSock = oOrb.getSocket(oEx, getHostPort(i2), True)
            i2 = i2 + 1
            If oEx.isSet Then
                If i2 >= iAddrCnt Then
                    GoTo ExHandler
                End If
                Call oEx.unSet
            Else
                iAddrIdx = i2
                Exit Do
            End If
        Loop
    End If
    Call oOut.sendGIOPToSocket(oEx, 0, oSock) '0 = Request
    If oEx.isSet Then
        'WSAECONNABORTED or WSAECONNRESET
        If oEx.Number = 10053 Or oEx.Number = 10054 Then
            'If you send oneway only, than "Connection aborted" is raised
            'To raise "connection refused" next time:
            Call oOrb.ungetSocket(getHostPort(iAddrIdx - 1), True)
            iAddrIdx = 0
        End If
        GoTo ExHandler
    End If
    'oneway?
    If Not lastResponseExpected Then
        Set invokeReq = Nothing
        Exit Function
    End If
    
    Dim oIn As New cOrbStream
    Call oIn.initBuffer(1024, oOrb)
    
    Dim msgType As Byte
    Dim reqId As Long, seqSC As Long, i1 As Long, repStatus As Long
    'Receive GIOP Message Header
    msgType = oIn.recvGIOPFromSocket(oEx, oSock)
    If oEx.isSet Then
        If oEx.Number = 10058 And Not recvAgain Then 'WSAESHUTDOWN
            'Connection closed by Server
            Call oEx.unSet
            Call oOrb.ungetSocket(getHostPort(iAddrIdx - 1), True)
            iAddrIdx = 0
            recvAgain = True
            GoTo tryAgain
        End If
        GoTo ExHandler
    End If
    If msgType <> 1 Then '1 = GIOP Reply
        Call oEx.setMe("Unknown GIOP msgType: " & msgType)
        GoTo ExHandler
    End If
    
    'Read GIOP Reply Header
    If oIn.getGIOPVersion <> "1.2" Then
        'IOP::ServiceContextList service_context;
        seqSC = oIn.read_ulong(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        For i1 = 1 To seqSC
            Call oIn.read_ulong(oEx)
            Call oIn.readSkip(oEx, oIn.read_ulong(oEx))
        Next i1
        'unsigned long request_id;
        reqId = oIn.read_ulong(oEx)
        'ReplyStatusType reply_status;
        repStatus = oIn.read_ulong(oEx)
    Else
        'unsigned long request_id;
        reqId = oIn.read_ulong(oEx)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'ReplyStatusType reply_status;
        repStatus = oIn.read_ulong(oEx)
        'IOP::ServiceContextList service_context;
        seqSC = oIn.read_ulong(oEx)
        For i1 = 1 To seqSC
            Call oIn.read_ulong(oEx)
            Call oIn.readSkip(oEx, oIn.read_ulong(oEx))
        Next i1
    End If
    
    If reqId <> lastReqId Then
        Call oEx.setMe("Unexpected RequestId: " & reqId & " <> " & lastReqId)
        GoTo ExHandler
    End If
    
    If repStatus = 0 Then
        'NO_EXCEPTION
        Set invokeReq = oIn
    ElseIf repStatus = 1 Then
        'USER_EXCEPTION
        Call oEx.setMe("Unknown USER_EXCEPTION", Kind:=oIn)
        GoTo ExHandler
    ElseIf repStatus = 2 Then
        'SYSTEM_EXCEPTION
        Dim oSystemEx As New cOrbSystemException
        Call oSystemEx.readMe(oEx, oIn)
        If oEx.isSet Then
            GoTo ExHandler
        End If
        Call oEx.setMe(oSystemEx.Description, Kind:=oSystemEx)
        GoTo ExHandler
    Else
        Call oEx.setMe("Unknown repStatus: " & repStatus)
        GoTo ExHandler
    End If
    
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("invokeReq: ")
End Function

