VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbStream"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Copyright (c) 1999 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.

Option Explicit

'Common Data Representation (CDR)

Private buffer() As Byte
Private bufOff As Long  'Offset (= bufStart)
Private bufEof As Long  '(= bufEnd + 1), (bufLen = bufEof - bufStart)
Private bufPos As Long  'Next Position (buffer(bufPos))
Private bLittleEndian As Boolean

'Encapsulation Stack
Private Type tEncap
    bufOff As Long
    bufEof As Long
    bufPos As Long
    bLittleEndian As Boolean
End Type
Private encapCnt As Long
Private encaps() As tEncap

'ObjRef
Private oOrb As cOrbImpl

'GIOP
Private sGIOPVersion As String
Private bMoreFrags As Boolean

'CopyRect();
'Private Declare Function dllCopy16B Lib "user32" Alias "CopyRect" _
'    (ByRef lpDestRect As Any, ByRef lpSourceRect As Any) As Long

'RtlMoveMemory();
Private Declare Sub dllMoveMem Lib "kernel32" Alias "RtlMoveMemory" _
    (ByRef hpvDest As Any, ByRef hpvSource As Any, ByVal cbCopy As Long)

'lstrcpyA();
Private Declare Function dllStrCpy Lib "kernel32" Alias "lstrcpyA" _
    (ByRef lpString1 As Any, ByVal lpString2 As String) As Long


Private Sub Class_Terminate()
    Set oOrb = Nothing
End Sub

Public Sub initBuffer(ByVal lSize As Long, ByVal Orb As cOrbImpl)
    ReDim buffer(0 To lSize - 1)
    bufOff = 0
    bufEof = bufOff
    bufPos = 0
    bLittleEndian = False
    encapCnt = 0
    ReDim encaps(0 To 4)
    Set oOrb = Orb
End Sub

Public Sub initGIOPOut(ByVal oEx As cOrbException, _
    ByVal sSetGIOPVersion As String, ByVal Orb As cOrbImpl)
    
    Call initBuffer(1024, Orb)
    bLittleEndian = False
    sGIOPVersion = sSetGIOPVersion
    bMoreFrags = False
    
    Call write_octet(oEx, Asc("G"))
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call write_octet(oEx, Asc("I"))
    Call write_octet(oEx, Asc("O"))
    Call write_octet(oEx, Asc("P"))
    Call write_octet(oEx, Val(Mid$(sGIOPVersion, 1, 1)))
    Call write_octet(oEx, Val(Mid$(sGIOPVersion, 3, 1)))
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call write_skip(6)
    Exit Sub
ExHandler:
    Call oEx.addPrefix("initGIOPOut: ")
End Sub

Public Sub sendGIOPToSocket(ByVal oEx As cOrbException, ByVal msgType As Byte, _
    sock As cOrbSocket)
    
    Call setPos(oEx, 6)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    If sGIOPVersion = "1.0" Then
        Call write_boolean(oEx, bLittleEndian)
    Else
        Dim bb As Byte
        bb = 0
        If bLittleEndian Then
            bb = bb + 1
        End If
        If bMoreFrags Then
            bb = bb + 2
        End If
        Call write_octet(oEx, bb)
    End If
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call write_octet(oEx, msgType)
    Call write_ulong(oEx, bufEof - 12)
    
    Call sock.send_buffer(oEx, buffer, bufEof)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("sendGIOP: ")
End Sub

'Convert contents of an OrbStream in an IOR string
Public Sub sendToIOR(ByVal oEx As cOrbException, ByRef sIOR As String)
    sIOR = "IOR:"
    Call setPos(oEx, 0)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    For bufPos = 0 To bufEof - 1
        If buffer(bufPos) <= &HF Then
            sIOR = sIOR & "0"
        End If
        sIOR = sIOR & Hex$(buffer(bufPos))
    Next bufPos
    Exit Sub
ExHandler:
    Call oEx.addPrefix("sendToIOR: ")
End Sub

'Convert an IOR string in an OrbStream
Public Sub recvFromIOR(ByRef sIOR As String)
    bufOff = 0
    bufEof = 0
    bufPos = 0
    Call writeEnsure((Len(sIOR) - 3) \ 2)
    'Convert string into sequence of octets
    For bufPos = 0 To bufEof - 1
        buffer(bufPos) = Val("&H" & Mid$(sIOR, bufPos * 2 + 5, 2))
    Next bufPos
    bufPos = 0
End Sub

Public Function recvGIOPFromSocket(ByVal oEx As cOrbException, _
    ByVal sock As cOrbSocket) As Byte
    bufOff = 0
    bufEof = 0
    bufPos = 0
    Call writeEnsure(12)
    Call sock.recv_buffer(oEx, buffer, bufPos, bufEof)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    
    If read_octet(oEx) <> Asc("G") Or read_octet(oEx) <> Asc("I") _
        Or read_octet(oEx) <> Asc("O") Or read_octet(oEx) <> Asc("P") Then
        Call oEx.setMe("GIOP magic is wrong.")
        GoTo ExHandler
    End If
    sGIOPVersion = read_octet(oEx) & "." & read_octet(oEx)
    
    If sGIOPVersion = "1.0" Then
        bLittleEndian = read_boolean(oEx)
        bMoreFrags = False
    Else
        Dim bb As Byte
        bb = read_octet(oEx)
        bLittleEndian = (bb Mod 2 >= 1)
        bMoreFrags = (bb Mod 4 >= 2)
    End If
    recvGIOPFromSocket = read_octet(oEx)
    
    Dim msgSize As Long
    msgSize = read_ulong(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call writeEnsure(msgSize)
    Call sock.recv_buffer(oEx, buffer, bufPos, bufEof - bufPos)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ExHandler:
    Call oEx.addPrefix("recvGIOP: ")
End Function

Public Function getGIOPVersion() As String
    getGIOPVersion = sGIOPVersion
End Function

Public Property Get littleEndian() As Boolean
    littleEndian = bLittleEndian
End Property

Public Function getPos() As Long
    getPos = bufPos
End Function

Public Sub setPos(ByVal oEx As cOrbException, ByVal newBufPos As Long)
    If newBufPos < bufOff Or newBufPos > bufEof Then
        Call oEx.setMe("Invalid newBufPos: " & newBufPos)
        GoTo ExHandler
    End If
    bufPos = newBufPos
    Exit Sub
ExHandler:
    Call oEx.addPrefix("setPos: ")
End Sub

Public Sub readSkip(ByVal oEx As cOrbException, ByVal skiplen As Long)
    If skiplen < 0 Or bufPos + skiplen > bufEof Then
        Call oEx.setMe("Unexpected skiplen: " & skiplen)
        GoTo ExHandler
    End If
    bufPos = bufPos + skiplen
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readSkip: ")
End Sub

'First read sequence len
Public Sub readEncapOpen(ByVal oEx As cOrbException, ByVal seqLen As Long)
    If seqLen < 0 Or bufPos + seqLen > bufEof Then
        Call oEx.setMe("Unexpected seqlen: " & seqLen)
        GoTo ExHandler
    End If
    If encapCnt > UBound(encaps) Then
        ReDim Preserve encaps(0 To encapCnt + 10)
    End If
    encaps(encapCnt).bufEof = bufEof
    encaps(encapCnt).bufOff = bufOff
    encaps(encapCnt).bufPos = bufPos + seqLen
    encaps(encapCnt).bLittleEndian = bLittleEndian
    encapCnt = encapCnt + 1
    bufOff = bufPos
    bufEof = bufOff + seqLen
    bLittleEndian = read_boolean(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readEncapOpen: ")
End Sub

Public Sub readEncapClose(ByVal oEx As cOrbException)
    If encapCnt = 0 Then
        Call oEx.setMe("Unexpected EncapClose")
        GoTo ExHandler
    End If
    encapCnt = encapCnt - 1
    bufEof = encaps(encapCnt).bufEof
    bufOff = encaps(encapCnt).bufOff
    bufPos = encaps(encapCnt).bufPos
    bLittleEndian = encaps(encapCnt).bLittleEndian
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readEncapClose: ")
End Sub

Public Function read_octet(ByVal oEx As cOrbException) As Byte
    On Error GoTo ErrHandler
    read_octet = buffer(bufPos)
    bufPos = bufPos + 1
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("read_octet: ")
End Function

'Used by sequence <octet> reader
Public Sub readOctets(ByVal oEx As cOrbException, _
    ByRef seqArr() As Byte, ByVal seqLen As Long)
    If seqLen < 0 Or bufPos + seqLen > bufEof Then
        Call oEx.setMe("Unexpected len: " & seqLen)
        GoTo ExHandler
    End If
    If seqLen = 0 Then
        'Dim seqCnt As Long, seqEnd As Long
        'seqEnd = LBound(seqArr) + seqLen - 1
        'For seqCnt = LBound(seqArr) To seqEnd
        '    seqArr(seqCnt) = buffer(bufPos)
        '    bufPos = bufPos + 1
        'Next seqCnt
    Else
        If UBound(seqArr) - LBound(seqArr) + 1 < seqLen Then
            Call oEx.setMe("seqArr too small, need: " & seqLen)
            GoTo ExHandler
        End If
        Call dllMoveMem(seqArr(LBound(seqArr)), buffer(bufPos), seqLen)
        bufPos = bufPos + seqLen
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readSeqOctet: ")
End Sub

'sequence <octet>
Public Sub readSeqOctet(ByVal oEx As cOrbException, ByRef seqArr() As Byte)
    Dim seqLen As Long
    seqLen = read_ulong(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    If seqLen = 0 Then
        'Second argument of MidB is always 1 for the first byte
        seqArr = MidB(buffer, 1 + bufPos, seqLen)
        'bufPos = bufPos + seqLen
    Else
        ReDim seqArr(0 To seqLen - 1)
        Call readOctets(oEx, seqArr, seqLen)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readSeqOctet: ")
End Sub

Public Function read_boolean(ByVal oEx As cOrbException) As Boolean
    On Error GoTo ErrHandler
    
    Dim bb As Byte
    bb = buffer(bufPos)
    bufPos = bufPos + 1

    If bb = 1 Then
        read_boolean = True
    ElseIf bb = 0 Then
        read_boolean = False
    Else
        Call oEx.setMe("Unexpected value: " & bb & ", bufpos= " & bufPos)
        GoTo ExHandler
    End If
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("read_boolean: ")
End Function

Public Function read_short(ByVal oEx As cOrbException) As Integer
    On Error GoTo ErrHandler
    ' Alignment
    If (bufPos - bufOff) Mod 2 > 0 Then
        bufPos = bufPos + 1
    End If
    
    If bLittleEndian Then
        If buffer(bufPos + 1) >= &H80 Then
            read_short = (CInt(buffer(bufPos + 1) Xor &HFF) * &H100 _
                + CInt(buffer(bufPos))) Xor &HFF00
        Else
            read_short = CInt(buffer(bufPos + 1)) * &H100 _
                + CInt(buffer(bufPos))
        End If
    Else
        If buffer(bufPos) >= &H80 Then
            read_short = (CInt(buffer(bufPos) Xor &HFF) * &H100 _
                + CInt(buffer(bufPos + 1))) Xor &HFF00
        Else
            read_short = CInt(buffer(bufPos)) * &H100 _
                + CInt(buffer(bufPos + 1))
        End If
    End If
    bufPos = bufPos + 2
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("read_short: ")
End Function

Public Function read_ushort(ByVal oEx As cOrbException) As Integer
    read_ushort = read_short(oEx)
End Function

Public Function read_long(ByVal oEx As cOrbException) As Long
    On Error GoTo ErrHandler
    ' Alignment
    If (bufPos - bufOff) Mod 4 > 0 Then
        bufPos = bufPos + 4 - ((bufPos - bufOff) Mod 4)
    End If
    
    If bLittleEndian Then
        If buffer(bufPos + 3) >= &H80 Then
            read_long = ((((CLng(buffer(bufPos + 3) Xor &HFF) * &H100 _
                + CLng(buffer(bufPos + 2))) * &H100 _
                + CLng(buffer(bufPos + 1))) * &H100 _
                + CLng(buffer(bufPos)))) Xor &HFF000000
        Else
            read_long = (((CLng(buffer(bufPos + 3)) * &H100 _
                + CLng(buffer(bufPos + 2))) * &H100 _
                + CLng(buffer(bufPos + 1))) * &H100 _
                + CLng(buffer(bufPos)))
        End If
    Else
        If buffer(bufPos) >= &H80 Then
            read_long = ((((CLng(buffer(bufPos) Xor &HFF) * &H100 _
                + CLng(buffer(bufPos + 1))) * &H100 _
                + CLng(buffer(bufPos + 2))) * &H100 _
                + CLng(buffer(bufPos + 3)))) Xor &HFF000000
        Else
            read_long = (((CLng(buffer(bufPos)) * &H100 _
                + CLng(buffer(bufPos + 1))) * &H100 _
                + CLng(buffer(bufPos + 2))) * &H100 _
                + CLng(buffer(bufPos + 3)))
        End If
    End If
    bufPos = bufPos + 4
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("read_long: ")
End Function

Public Function read_ulong(ByVal oEx As cOrbException) As Long
    read_ulong = read_long(oEx)
End Function

'First version was written by Holger Beer
Public Function readFloat(ByVal oEx As cOrbException) As Single
    Dim i As Long
    Dim bytes(0 To 3) As Byte
    
    On Error GoTo ErrHandler
    'Alignment
    If (bufPos - bufOff) Mod 4 > 0 Then
        bufPos = bufPos + 4 - ((bufPos - bufOff) Mod 4)
    End If
        
    If bLittleEndian Then
        For i = 0 To 3
            bytes(i) = buffer(bufPos + i)
        Next
    Else
        For i = 0 To 3
            bytes(i) = buffer(bufPos + 3 - i)
        Next
    End If
    Call dllMoveMem(readFloat, bytes(0), 4&)
    bufPos = bufPos + 4
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("readFloat: ")
End Function

'First version was written by Holger Beer
Public Function readDouble(ByVal oEx As cOrbException) As Double
    Dim i As Long
    Dim bytes(0 To 7) As Byte
    
    On Error GoTo ErrHandler
    'Alignment
    If (bufPos - bufOff) Mod 8 > 0 Then
        bufPos = bufPos + 8 - ((bufPos - bufOff) Mod 8)
    End If
        
    If bLittleEndian Then
        For i = 0 To 7
            bytes(i) = buffer(bufPos + i)
        Next
    Else
        For i = 0 To 7
            bytes(i) = buffer(bufPos + 7 - i)
        Next
    End If
    Call dllMoveMem(readDouble, bytes(0), 8&)
    bufPos = bufPos + 8
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("readDouble: ")
End Function

Public Function read_string(ByVal oEx As cOrbException) As String
    On Error GoTo ErrHandler
    Dim strlen As Long
    strlen = read_ulong(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    If strlen <= 0 Then
        Call oEx.setMe("Unexpected string value: strlen= " & strlen)
        GoTo ExHandler
    End If
    'Second argument of MidB is always 1 for the first byte
    read_string = StrConv(MidB(buffer, 1 + bufPos, strlen - 1), vbUnicode)
    'buffer(bufpos + strlen -1) is always equals Chr$(0)
    bufPos = bufPos + strlen
    Exit Function
ErrHandler:
    Call oEx.setMe(Err.Description, Err.Number)
ExHandler:
    Call oEx.addPrefix("read_string: ")
End Function

Public Function read_ObjRef(ByVal oEx As cOrbException) As cOrbObjRef
    Set read_ObjRef = New cOrbObjRef
    If read_ObjRef.readMe(oEx, oOrb, Me) Then
        Set read_ObjRef = Nothing
    End If
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Function
ExHandler:
    Set read_ObjRef = Nothing
    Call oEx.addPrefix("read_ObjRef: ")
End Function

Public Sub writeEnsure(ByVal minSize As Long)
    If bufPos + minSize <= bufEof Then
        Exit Sub
    End If
    bufEof = bufPos + minSize
    If bufEof <= UBound(buffer) + 1 Then
        Exit Sub
    End If
    If minSize < 512 Then
        minSize = 512
    End If
    minSize = UBound(buffer) + 2 * minSize
    If bufPos = 0 Then
        ReDim buffer(0 To minSize)
    Else
        ReDim Preserve buffer(0 To minSize)
    End If
End Sub

Public Sub write_skip(ByVal skiplen As Long)
    Call writeEnsure(skiplen)
    bufPos = bufPos + skiplen
End Sub

Public Sub writeEncapOpen(ByVal oEx As cOrbException, _
    ByVal newLittleEndian As Boolean)
    
    Call write_long(oEx, 0) 'Will be overwritten by writeEncapClose()
    If oEx.isSet Then
        GoTo ExHandler
    End If
    If encapCnt > UBound(encaps) Then
        ReDim Preserve encaps(0 To encapCnt + 10)
    End If
    encaps(encapCnt).bufEof = bufEof
    encaps(encapCnt).bufOff = bufOff
    encaps(encapCnt).bufPos = bufPos
    encaps(encapCnt).bLittleEndian = bLittleEndian
    encapCnt = encapCnt + 1
    bufOff = bufPos
    bufEof = bufOff
    bLittleEndian = newLittleEndian
    Call write_boolean(oEx, bLittleEndian)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeEncapOpen: ")
End Sub

Public Sub writeEncapClose(ByVal oEx As cOrbException)
    If encapCnt = 0 Then
        Call oEx.setMe("Unexpected EncapClose")
        GoTo ExHandler
    End If
    encapCnt = encapCnt - 1
    Dim seqLen As Long
    seqLen = bufEof - bufOff
    bufEof = encaps(encapCnt).bufEof + seqLen
    bufOff = encaps(encapCnt).bufOff
    bufPos = encaps(encapCnt).bufPos - 4
    bLittleEndian = encaps(encapCnt).bLittleEndian
    Call write_long(oEx, seqLen)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call write_skip(seqLen)
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeEncapClose: ")
End Sub

Public Sub write_octet(ByVal oEx As cOrbException, ByVal wVal As Byte)
    Call writeEnsure(1)
    buffer(bufPos) = wVal
    bufPos = bufPos + 1
End Sub

'Used by sequence <octet> writer
Public Sub writeOctets(ByVal oEx As cOrbException, _
    ByRef seqArr() As Byte, ByVal seqLen As Long)
    Call writeEnsure(seqLen)
    If seqLen = 0 Then
        'Dim seqCnt As Long, seqEnd As Long
        'seqEnd = LBound(seqArr) + seqLen - 1
        'For seqCnt = LBound(seqArr) To seqEnd
        '    buffer(bufPos) = seqArr(seqCnt)
        '    bufPos = bufPos + 1
        'Next seqCnt
    Else
        If UBound(seqArr) - LBound(seqArr) + 1 < seqLen Then
            Call oEx.setMe("seqArr too small, need: " & seqLen)
            GoTo ExHandler
        End If
        Call dllMoveMem(buffer(bufPos), seqArr(LBound(seqArr)), seqLen)
        bufPos = bufPos + seqLen
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeOctets: ")
End Sub

'sequence <octet>
Public Sub writeSeqOctet(ByVal oEx As cOrbException, _
    ByRef seqArr() As Byte, ByVal seqLen As Long)
    Call write_ulong(oEx, seqLen)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call writeOctets(oEx, seqArr, seqLen)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeSeqOctet: ")
End Sub

Public Sub write_boolean(ByVal oEx As cOrbException, ByVal wVal As Boolean)
    Call writeEnsure(1)
    If wVal Then
        buffer(bufPos) = 1
    Else
        buffer(bufPos) = 0
    End If
    bufPos = bufPos + 1
End Sub

Public Sub write_short(ByVal oEx As cOrbException, ByVal wVal As Integer)
    ' Alignment
    If (bufPos - bufOff) Mod 2 > 0 Then
        bufPos = bufPos + 1
    End If
    Call writeEnsure(2)
    
    If wVal >= 0 Then
        If bLittleEndian Then
            buffer(bufPos) = wVal And &HFF 'Mod &H100
            buffer(bufPos + 1) = (wVal \ &H100) And &HFF 'Mod &H100
        Else
            buffer(bufPos + 1) = wVal And &HFF 'Mod &H100
            buffer(bufPos) = (wVal \ &H100) And &HFF 'Mod &H100
        End If
    Else
        If bLittleEndian Then
            buffer(bufPos) = wVal And &HFF 'Mod &H100
            wVal = ((wVal Xor &HFFFF) \ &H100) Xor &HFF
            buffer(bufPos + 1) = wVal And &HFF 'Mod &H100
        Else
            buffer(bufPos + 1) = wVal And &HFF 'Mod &H100
            wVal = ((wVal Xor &HFFFF) \ &H100) Xor &HFF
            buffer(bufPos) = wVal And &HFF 'Mod &H100
        End If
    End If
    bufPos = bufPos + 2
End Sub

Public Sub write_ushort(ByVal oEx As cOrbException, ByVal wVal As Integer)
    Call write_short(oEx, wVal)
End Sub

Public Sub write_long(ByVal oEx As cOrbException, ByVal wVal As Long)
    ' Alignment
    If (bufPos - bufOff) Mod 4 > 0 Then
        bufPos = bufPos + 4 - ((bufPos - bufOff) Mod 4)
    End If
    Call writeEnsure(4)
    
    If wVal >= 0 Then
        If bLittleEndian Then
            buffer(bufPos) = wVal And &HFF 'Mod &H100
            buffer(bufPos + 1) = (wVal \ &H100) And &HFF 'Mod &H100
            buffer(bufPos + 2) = (wVal \ &H10000) And &HFF 'Mod &H100
            buffer(bufPos + 3) = (wVal \ &H1000000) And &HFF 'Mod &H100
        Else
            buffer(bufPos + 3) = wVal And &HFF 'Mod &H100
            buffer(bufPos + 2) = (wVal \ &H100) And &HFF 'Mod &H100
            buffer(bufPos + 1) = (wVal \ &H10000) And &HFF 'Mod &H100
            buffer(bufPos) = (wVal \ &H1000000) And &HFF 'Mod &H100
        End If
    Else
        If bLittleEndian Then
            buffer(bufPos) = wVal And &HFF 'Mod &H100
            wVal = ((wVal Xor &HFFFFFFFF) \ &H100) Xor &HFFFFFF
            buffer(bufPos + 1) = wVal And &HFF 'Mod &H100
            buffer(bufPos + 2) = (wVal \ &H100) And &HFF 'Mod &H100
            buffer(bufPos + 3) = (wVal \ &H10000) And &HFF 'Mod &H100
        Else
            buffer(bufPos + 3) = wVal And &HFF 'Mod &H100
            wVal = ((wVal Xor &HFFFFFFFF) \ &H100) Xor &HFFFFFF
            buffer(bufPos + 2) = wVal And &HFF 'Mod &H100
            buffer(bufPos + 1) = (wVal \ &H100) And &HFF 'Mod &H100
            buffer(bufPos) = (wVal \ &H10000) And &HFF 'Mod &H100
        End If
    End If
    bufPos = bufPos + 4
End Sub

Public Sub write_ulong(ByVal oEx As cOrbException, ByVal wVal As Long)
    Call write_long(oEx, wVal)
End Sub

'First version was written by Holger Beer
Public Sub writeFloat(ByVal oEx As cOrbException, ByVal wVal As Single)
    Dim i As Long
    Dim bytes(0 To 3) As Byte
    
    'Alignment
    If (bufPos - bufOff) Mod 4 > 0 Then
        bufPos = bufPos + 4 - ((bufPos - bufOff) Mod 4)
    End If
    Call writeEnsure(4)
    
    Call dllMoveMem(bytes(0), wVal, 4&)
    If bLittleEndian Then
        For i = 0 To 3
            buffer(bufPos + i) = bytes(i)
        Next
    Else
        For i = 0 To 3
            buffer(bufPos + 3 - i) = bytes(i)
        Next
    End If
    
    bufPos = bufPos + 4
End Sub

'First version was written by Holger Beer
Public Sub writeDouble(ByVal oEx As cOrbException, ByVal wVal As Double)
    Dim i As Long
    Dim bytes(0 To 7) As Byte
    
    'Alignment
    If (bufPos - bufOff) Mod 8 > 0 Then
        bufPos = bufPos + 8 - ((bufPos - bufOff) Mod 8)
    End If
    Call writeEnsure(8)
    
    Call dllMoveMem(bytes(0), wVal, 8&)
    If bLittleEndian Then
        For i = 0 To 7
            buffer(bufPos + i) = bytes(i)
        Next
    Else
        For i = 0 To 7
            buffer(bufPos + 7 - i) = bytes(i)
        Next
    End If
    
    bufPos = bufPos + 8
End Sub

Public Sub write_string(ByVal oEx As cOrbException, ByRef wVal As String)
    Dim strlen As Long
    strlen = Len(wVal)
    Call write_ulong(oEx, strlen + 1)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call writeEnsure(strlen + 1)
    Call dllStrCpy(buffer(bufPos), wVal)
    'Dim i1 As Long
    'For i1 = 0 To strlen - 1
    '    buffer(bufPos + i1) = Asc(Mid$(wVal, i1 + 1, 1))
    'Next i1
    buffer(bufPos + strlen) = 0
    bufPos = bufPos + strlen + 1
    Exit Sub
ExHandler:
    Call oEx.addPrefix("write_string: ")
End Sub

Public Sub write_ObjRef(ByVal oEx As cOrbException, _
    ByVal oObjRef As cOrbObjRef)
    
    If oObjRef Is Nothing Then
        'string type_id;
        Call write_string(oEx, "")
        If oEx.isSet Then
            GoTo ExHandler
        End If
        'sequence <TaggedProfile> profiles;
        Call write_ulong(oEx, 0)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    Else
        Call oObjRef.writeMe(oEx, Me)
        If oEx.isSet Then
            GoTo ExHandler
        End If
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("write_ObjRef: ")
End Sub

