VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbSystemException"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Copyright (c) 1999 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.

Option Explicit

Private Const sExPrefix As String = "IDL:omg.org/CORBA/"

Public ExceptionId As String
Public MinorCodeValue As Long
Public CompletionStatus As Long

Public Property Get MinorOMGVMCID() As Long
    MinorOMGVMCID = &H4F4D0000
End Property

Public Property Get CompletedYES() As Long
    CompletedYES = 0
End Property

Public Property Get CompletedNO() As Long
    CompletedNO = 1
End Property

Public Property Get CompletedMAYBE() As Long
    CompletedMAYBE = 2
End Property

Public Sub setUNKNOWN(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "UNKNOWN:1.0"
End Sub
    
Public Sub setBADPARAM(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "BAD_PARAM:1.0"
End Sub

Public Sub setNOMEMORY(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "NO_MEMORY:1.0"
End Sub

Public Sub setIMPLIMIT(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "IMP_LIMIT:1.0"
End Sub

Public Sub setCOMMFAILURE(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "COMM_FAILURE:1.0"
End Sub

Public Sub setINVOBJREF(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "INV_OBJREF:1.0"
End Sub

Public Sub setNOPERMISSION(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "NO_PERMISSION:1.0"
End Sub

Public Sub setINTERNAL(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "INTERNAL:1.0"
End Sub

Public Sub setMARSHAL(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "MARSHAL:1.0"
End Sub

Public Sub setINITIALIZE(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "INITIALIZE:1.0"
End Sub

Public Sub setNOIMPLEMENT(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "NO_IMPLEMENT:1.0"
End Sub

Public Sub setBADTYPECODE(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "BAD_TYPECODE:1.0"
End Sub

Public Sub setBADOPERATION(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "BAD_OPERATION:1.0"
End Sub

Public Sub setNORESOURCES(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "NO_RESOURCES:1.0"
End Sub

Public Sub setNORESPONSE(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "NO_RESPONSE:1.0"
End Sub

Public Sub setPERSISTSTORE(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "PERSIST_STORE:1.0"
End Sub

Public Sub setBADINVORDER(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "BAD_INV_ORDER:1.0"
End Sub

Public Sub setTRANSIENT(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "TRANSIENT:1.0"
End Sub

Public Sub setFREEMEM(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "FREE_MEM:1.0"
End Sub

Public Sub setINVIDENT(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "INV_IDENT:1.0"
End Sub

Public Sub setINVFLAG(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "INV_FLAG:1.0"
End Sub

Public Sub setINTFREPOS(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "INTF_REPOS:1.0"
End Sub

Public Sub setBADCONTEXT(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "BAD_CONTEXT:1.0"
End Sub

Public Sub setOBJADAPTER(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "OBJ_ADAPTER:1.0"
End Sub

Public Sub setDATACONVERSION(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "DATA_CONVERSION:1.0"
End Sub

Public Sub setOBJECTNOTEXIST(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "OBJECT_NOT_EXIST:1.0"
End Sub

Public Sub setTRANSACTIONREQUIRED(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "TRANSACTION_REQUIRED:1.0"
End Sub

Public Sub setTRANSACTIONROLLEDBACK(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "TRANSACTION_ROLLEDBACK:1.0"
End Sub

Public Sub setINVALIDTRANSACTION(ByVal minor As Long, ByVal completed As Long)
    MinorCodeValue = minor
    CompletionStatus = completed
    ExceptionId = sExPrefix & "INVALID_TRANSACTION:1.0"
End Sub

'Helper
Public Sub readMe(ByVal oEx As cOrbException, oIn As cOrbStream)
    'GIOP::SystemExceptionReplyBody
    'string exception_id;
    'unsigned long minor_code_value;
    'unsigned long completion_status;
    ExceptionId = oIn.read_string(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    MinorCodeValue = oIn.read_ulong(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    CompletionStatus = oIn.read_ulong(oEx)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("readSystemException: ")
End Sub

'Helper
Public Sub writeMe(ByVal oEx As cOrbException, ByVal oOut As cOrbStream)
    Call oOut.write_string(oEx, ExceptionId)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call oOut.write_ulong(oEx, MinorCodeValue)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Call oOut.write_ulong(oEx, CompletionStatus)
    If oEx.isSet Then
        GoTo ExHandler
    End If
    Exit Sub
ExHandler:
    Call oEx.addPrefix("writeSystemException: ")
End Sub

Public Property Get Description() As String
    Description = "SYSTEM_EXCEPTION: " & ExceptionId _
        & ", " & MinorCodeValue & ", " & CompletionStatus
End Property

