Attribute VB_Name = "mGlobal"
Option Explicit

Dim oOrb As cOrbImpl

Dim sOldManagerIOR As String
Dim oDBManager As c_DBManager
Dim oDBConnection As c_DBConnection

Public Sub initOrb()
    'Get an ORB
    Set oOrb = VBOrb.init(ORBId:="")
End Sub

Public Sub initDBManager(ByVal sIOR As String)
    On Error GoTo ErrHandler
    If oDBManager Is Nothing Or sOldManagerIOR <> sIOR Then
        Dim oObjRef As cOrbObjRef
        Set oObjRef = oOrb.stringToObject(sIOR)
        Set oDBManager = m_DBManager.narrow(oObjRef)
        sOldManagerIOR = sIOR
    End If
    Exit Sub
ErrHandler:
    Set oDBManager = Nothing
    Call VBOrb.ErrReraise("initDBManager")
End Sub

Public Sub shutdownServer()
    If oDBManager Is Nothing Then
        Call VBOrb.ErrRaise(1, _
            "No valid DBManager. Please fill up IOR field.")
    End If
    Call oDBManager.shutdownServer
End Sub

Public Sub openDBConnection(ByRef oEx As VBOrb.cOrbException, _
    ByVal sURL As String, ByVal sUser As String, ByVal sPassword As String, _
    ByRef oDBWarns As c_DBWarningSeq)
    On Error GoTo ErrHandler
    If oDBManager Is Nothing Then
        Call VBOrb.ErrRaise(1, _
            "No valid DBManager. Please fill up IOR field.")
    End If
    Set oDBConnection = oDBManager.getConnection(sURL, sUser, _
        sPassword, oDBWarns)
    Exit Sub
ExHandler:
    Set oEx = VBOrb.getException()
    Exit Sub
ErrHandler:
    If VBOrb.ErrIsUserEx() Then Resume ExHandler
    Call VBOrb.ErrReraise("openDBConnection")
End Sub

Public Sub showExeptionBox(ByVal oEx As VBOrb.cOrbException)
    Select Case TypeName(oEx)
    Case "c_DBException"
        Dim oDBEx As c_DBException
        Set oDBEx = oEx
        Call MsgBox("DBException " & oDBEx.sqlcode & ", " _
            & oDBEx.sqlstate & vbCrLf & oDBEx.sqlmessage)
    Case Else
        Call MsgBox("Error " & oEx.Source & vbCrLf & oEx.Description)
    End Select
End Sub

Public Sub closeDBConnection(ByRef oEx As VBOrb.cOrbException, _
    ByRef oDBWarns As c_DBWarningSeq)
    On Error GoTo ErrHandler
    Call oDBConnection.closeSub(oDBWarns)
    Set oDBConnection = Nothing
    Exit Sub
ExHandler:
    Set oEx = VBOrb.getException()
    Exit Sub
ErrHandler:
    If VBOrb.ErrIsUserEx() Then Resume ExHandler
    Call VBOrb.ErrReraise("openDBConnection")
End Sub

Public Property Get DBConnection() As c_DBConnection
    Set DBConnection = oDBConnection
End Property
