Attribute VB_Name = "mGridServer"
Option Explicit

Public Sub Main()
    'To keep error handling working please switch following radio
    'button on in your Microsoft Visual Basic environment.
    'Menu: Tools|Options...|General|Break on Unhandled Errors
    'Or in german: Extras|Optionen...|Allgemein|Bei nicht verarbeiteten Fehlern
    On Error GoTo ErrHandler
    
    'Writing start message to logfile
    Dim sLogFile As String
    sLogFile = App.Path & "\GridServer.log"
    Call VBOrb.logMsg(sLogFile, "Starting Server")
    
    'Get an ORB with logging
    Dim oOrb As cOrbImpl
    Set oOrb = VBOrb.init(ORBId:="", OAPort:="1900", LogFile:=sLogFile)
    
    'Connect an object to the ORB. That object implements an interface.
    'That interface is defined in grid.idl file
    Dim oImpl As New c_gridMyServerImpl
    'corbaloc://1.1@HostName:1900/MyServer
    Call oOrb.Connect(oImpl, "MyServer") 'ObjectKey = "MyServer"

    'oOrb.run is waiting for client connections until shutdown. In this
    'example any client can shutdown the server by calling shutdownServer
    'method of MyServer. A non blocking way to keep the ORB working
    'would be to call oOrb.performWork by a timer periodically instead
    'of calling oOrb.run.
    Call oOrb.run
    
EndOfServer:
    Call VBOrb.logMsg(sLogFile, "End of Server")
    End
ErrHandler:
    Call VBOrb.logErr(sLogFile, "Main")
    Resume EndOfServer
End Sub

