VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbAny"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Copyright (c) 2000 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.

'Diese Klasse representiert entweder einen TypeCode oder TypeCode + Value
'Ein Value alleine ist ein Datenstrom.
'??? Orb beinhaltet Funktionen wie:
'Siehe TypeCode von Java 1.2 API
'For example, the following creates a TypeCode object for a string with a maximum of 30 characters:
' org.omg.CORBA.TypeCode tcString = orb.create_string_tc(30);
 
'The following creates a TypeCode object for an array of five strings:
' org.omg.CORBA.TypeCode tcArray = orb.create_array_tc(
'                                       5, TCKind.tk_string);

'??? TypeCode beinhaltet Funktionen wie:
'Diese Funktionen mssen hier in Any realisiert werden
'public abstract int member_count() Throws BadKind

'??? Any beinhaltet Funktionen wie:
'public abstract int extract_long() Throws BAD_OPERATION
'public abstract void insert_long(int l)


Option Explicit

Const tk_null As Long = 0
Const tk_void As Long = 1
Const tk_short As Long = 2
Const tk_long As Long = 3
Const tk_ushort As Long = 4
Const tk_ulong As Long = 5
Const tk_float As Long = 6
Const tk_double As Long = 7
Const tk_boolean As Long = 8
Const tk_char As Long = 9
Const tk_octet As Long = 10
Const tk_any As Long = 11
Const tk_TypeCode As Long = 12
Const tk_Principal As Long = 13
Const tk_objref As Long = 14
Const tk_struct As Long = 15
Const tk_union As Long = 16
Const tk_enum As Long = 17
Const tk_string As Long = 18
Const tk_sequence As Long = 19
Const tk_array As Long = 20
Const tk_alias As Long = 21
Const tk_except As Long = 22
Const tk_longlong As Long = 23
Const tk_ulonglong As Long = 24
Const tk_longdouble As Long = 25
Const tk_wchar As Long = 26
Const tk_wstring As Long = 27
Const tk_fixed As Long = 28
Const tk_value As Long = 29
Const tk_value_box As Long = 30
Const tk_native As Long = 31
Const tk_abstract_interface As Long = 32
Const tk_recursive As Long = &HFFFFFFFF

Private lTypeCode As Long 'tk_... value

Private iVal As Integer
Private lVal As Long
Private oVal As cOrbObjRef
Private sVal As String
Private anyValue As Variant

Private sTypeId As String
Private sTypeName As String

Private sMemberNames() As String
Private aMemberVals() As cOrbAny

'
Public Property Get TCKind() As Long
    TCKind = lTypeCode
End Property

'
Public Property Let TCKind(ByVal tk As Long)
    lTypeCode = tk
End Property

Public Sub setNull()
    lTypeCode = tk_null
    Set oVal = Nothing
    sVal = ""
    Erase sMemberNames
    Erase aMemberVals
End Sub

Public Function isNull() As Boolean
    isNull = (lTypeCode = tk_null)
End Function

Public Sub setShort(ByVal val As Integer)
    lTypeCode = tk_short
    iVal = val
End Sub

Public Function isShort() As Boolean
    isShort = (lTypeCode = tk_short)
End Function

Public Function getShort() As Integer
    getShort = iVal
End Function

Public Sub setLong(ByVal val As Long)
    lTypeCode = tk_long
    lVal = val
End Sub

Public Function isLong() As Boolean
    isLong = (lTypeCode = tk_long)
End Function

Public Function getLong() As Integer
    getLong = lVal
End Function

Public Sub setObjRef(ByVal name As String, ByVal val As cOrbObjRef)
    lTypeCode = tk_objref
    Set oVal = val
    sTypeId = oVal.TypeId
    sTypeName = name
End Sub

Public Function isObjRef() As Boolean
    isObjRef = (lTypeCode = tk_objref)
End Function

Public Function getObjRefName() As String
    getObjRefName = sTypeName
End Function

Public Function getObjRef() As cOrbObjRef
    Set getObjRef = oVal
End Function

Public Sub setStruct(ByVal name As String, ByVal lcnt As Long)
    lTypeCode = tk_struct
    sTypeId = ""
    sTypeName = name
    ReDim sMemberNames(1 To lcnt)
    ReDim aMemberVals(1 To lcnt)
End Sub

Public Sub setStructMName(ByVal indx As Long, ByVal name As String)
    sMemberNames(indx) = name
End Sub

Public Sub setStructMVal(ByVal indx As Long, ByVal val As cOrbAny)
    Set aMemberVals(indx) = val
End Sub

Public Function isStruct() As Boolean
    isStruct = (lTypeCode = tk_struct)
End Function

Public Function getStructName() As String
    getStructName = sTypeName
End Function

Public Function getStructCnt() As Long
    getStructCnt = UBound(sMemberNames) - LBound(sMemberNames) + 1
End Function

Public Function getStructMName(ByVal indx As Long) As String
    getStructMName = sMemberNames(indx)
End Function

Public Function getStructMVal(ByVal indx As Long) As cOrbAny
    Set getStructMVal = aMemberVals(indx)
End Function

Public Sub setString(ByVal val As String)
    lTypeCode = tk_string
    sVal = val
End Sub

Public Function isString() As Boolean
    isString = (lTypeCode = tk_string)
End Function

Public Function getString() As String
    getString = sVal
End Function

'Helper
Public Sub readMe(ByVal oIn As cOrbStream)
    On Error GoTo ErrHandler
    Call readType(oIn)
    Call readValue(oIn)
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("Any.readMe")
End Sub

'Helper
Public Sub readType(ByVal oIn As cOrbStream)
    On Error GoTo ErrHandler
    lTypeCode = oIn.readLong()
    Select Case lTypeCode
    Case tk_null To tk_Principal, tk_longlong To tk_wchar
    Case tk_objref
        lVal = oIn.readUlong()  ' complex type
        Call oIn.readEncapOpen(lVal)
        sTypeId = oIn.readString()
        sTypeName = oIn.readString()
        Call oIn.readEncapClose
    Case tk_struct
        lVal = oIn.readUlong()  ' complex type
        Call oIn.readEncapOpen(lVal)
        sTypeId = oIn.readString()
        sTypeName = oIn.readString()
        lVal = oIn.readUlong()
        ReDim sMemberNames(1 To lVal)
        ReDim aMemberVals(1 To lVal)
        For lVal = LBound(sMemberNames) To UBound(sMemberNames)
            sMemberNames(lVal) = oIn.readString()
            Set aMemberVals(lVal) = New cOrbAny
            Call aMemberVals(lVal).readType(oIn)
        Next lVal
        Call oIn.readEncapClose
    Case tk_string
        Call oIn.readUlong    'max length
    Case Else
        Call mVBOrb.ErrRaise(1, "Any type " & lTypeCode & " is unsupported")
    End Select
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("Any.readType")
End Sub

'Helper
Public Sub readValue(ByVal oIn As cOrbStream)
    On Error GoTo ErrHandler
    Select Case lTypeCode
    Case tk_null
    Case tk_long
        lVal = oIn.readLong()
    Case tk_objref
        Set oVal = oIn.readObjRef()
    Case tk_struct
        For lVal = LBound(sMemberNames) To UBound(sMemberNames)
            Call aMemberVals(lVal).readValue(oIn)
        Next lVal
    Case tk_string
        sVal = oIn.readString()
    Case Else
        Call mVBOrb.ErrRaise(1, "Any value " & lTypeCode & " is unsupported")
    End Select
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("Any.readValue")
End Sub

'Helper
Public Sub writeMe(ByVal oOut As cOrbStream)
    On Error GoTo ErrHandler
    Call writeType(oOut)
    Call writeValue(oOut)
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("Any.writeMe")
End Sub

'Helper
Public Sub writeType(ByVal oOut As cOrbStream)
    On Error GoTo ErrHandler
    Call oOut.writeLong(lTypeCode)
    Select Case lTypeCode
    Case tk_null To tk_Principal, tk_longlong To tk_wchar
    Case tk_objref
        Call oOut.writeEncapOpen(False) ' complex type
        Call oOut.writeString(sTypeId)
        Call oOut.writeString(sTypeName)
        Call oOut.writeEncapClose
    Case tk_struct
        Call oOut.writeEncapOpen(False) ' complex type
        Call oOut.writeString(sTypeId)
        Call oOut.writeString(sTypeName)
        Call oOut.writeUlong(UBound(sMemberNames) - LBound(sMemberNames) + 1)
        For lVal = LBound(sMemberNames) To UBound(sMemberNames)
            Call oOut.writeString(sMemberNames(lVal))
            Call aMemberVals(lVal).writeType(oOut)
        Next lVal
        Call oOut.writeEncapClose
    Case tk_string
        Call oOut.writeUlong(0) 'max length
    Case Else
        Call mVBOrb.ErrRaise(1, "Any type " & lTypeCode & " is unsupported")
    End Select
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("Any.writeType")
End Sub

'Helper
Public Sub writeValue(ByVal oOut As cOrbStream)
    On Error GoTo ErrHandler
    Select Case lTypeCode
    Case tk_null
    Case tk_long
        Call oOut.writeLong(lVal)
    Case tk_objref
        Call oOut.writeObjRef(oVal)
    Case tk_struct
        For lVal = LBound(sMemberNames) To UBound(sMemberNames)
            Call aMemberVals(lVal).writeValue(oOut)
        Next lVal
    Case tk_string
        Call oOut.writeString(sVal)
    Case Else
        Call mVBOrb.ErrRaise(1, "Any value " & lTypeCode & " is unsupported")
    End Select
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("Any.writeValue")
End Sub

