VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbObjRef"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Copyright (c) 1999 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.

'History:
'First LW implemetation was written by Mikael Gjrloff, Sweden, 2000-09-04

Option Explicit

'Set DebugMode = 0 to deactivate debug code in this class
#Const DebugMode = 0

#If DebugMode Then
    Private lClassDebugID As Long
#End If

Private oOrb As cOrbImpl

'Interoperable Object Reference (IOR)
'An IOR is a sequence of object-specific protocol profiles, plus a type ID.

'------ TypeId ---------
'TypeId example: IDL:foo/bar:1.0
Private sTypeId As String
'NullTypeID is a string which contains only a single terminating character.
'A NullTypeID is the only mechanism that can be used to represent the type
'CORBA::Object. TypeIDs may only be Null in any message, requiring the client
'to use existing knowledge or to consult the object, to determine interface
'types supported.
Const sNullTypeId As String = ""

'------ Profiles -------
'To support the Full-IOR conformance it is required to preserve all the
'semantic content of any IOR (including the ordering of each profile and its
'components). Only transformations which preserve semantics (e.g.,
'changing Byte order for encapsulation) are allowed.

'sequence <TaggedProfile> profiles;
Const TAG_INTERNET_IOP As Long = 0 'IIOP IOR Profile
Const TAG_MULTIPLE_COMPONENTS As Long = 1
Const TAG_SCCP_IOP As Long = 2 'See CORBA/IN Interworking specification
Private Type tTProf 'TaggedProfile
    ptag As Long 'ProfileId, unsigned long tag
    pdatlen As Long 'Profile data length
    pdata() As Byte 'Profile data, sequence <octet>
End Type
Private lTProfSeqLen As Long
Private TProfs() As tTProf 'sequence <TaggedProfile>

'------ Components -----
'Components of TAG_INTERNET_IOP profile
Const TAG_ALTERNATE_IIOP_ADDRESS As Long = 3

'Components of TAG_MULTIPLE_COMPONENTS profile
Const TAG_COMPLETE_OBJECT_KEY As Long = 5

'------ Used IIOP profile or -1
Private lSelectedProfile As Long

'IIOP Version (Major and Minor), example: &H0, &H100, &H101, &H102
Private iIIOPVersion As Integer

'Object key, example:    0x3A 3A 00 0F 2E 48 22 3C 01 3C 1F
Private baObjKey() As Byte

'Number of IIOP addresses, at least one
Private iAddrCnt As Integer

'Host, example:       "164.25.33.38"
Private sHosts(4) As String

'Port, example:       3821
Private iPorts(4) As Integer

'AddressingDisposition, 0 = KeyAddr, 1 = ProfileAddr, 2 = ReferenceAddr
Private iAddrDisp As Integer

'------ Components -----
'------ Components??? --
'Object references are immutable. That is at the time that they are
'created their policies are set in stone, and cannot be changed.

'0 = LW not tested, >0 = LW tested and required if not oLWObjRef is nothing
Private iLWCnt As Integer
'Mikael Gjrloff: Quiz: Any risk of a loop? Should there be a counter and an exit
'if run more than, say, twenty times and still is recieving LOCATION_FORWARD?
'It should never happen, but in my experience, a lot of things has happened
'that was not meant to... ;-)
Const LOCATION_FORWARD_LIMIT As Integer = 20
Private oLWObjRef As cOrbObjRef

'Id of a host connection slot or -1
Private lOrbConnId As Integer

Private Sub Class_Initialize()
    #If DebugMode Then
        lClassDebugID = mVBOrb.getNextClassDebugID()
        Debug.Print "'" & TypeName(Me) & "' " & lClassDebugID & " initialized"
    #End If
    'Set oOrb = Nothing
    'sTypeId = sNullTypeId
    'lTProfSeqLen = 0
    lSelectedProfile = -1
    'iAddrCnt = 0
    lOrbConnId = -1
End Sub

Private Sub Class_Terminate()
    'Do not call a function here which is using the Err object otherwise
    'you will get an Error 0 if Error is raised before Class_Terminate()
    'is called implicitly.
    If Not oOrb Is Nothing Then
        'Release something which VB cannot know if required
        If lOrbConnId >= 0 Then
            'MarkOnly = True because of above explanation
            'Testet with Error in
            Call oOrb.ConnOCIdFree(lOrbConnId, True)
            lOrbConnId = -1
        End If
        Set oOrb = Nothing
    End If
    #If DebugMode Then
        Debug.Print "'" & TypeName(Me) & "' " & CStr(lClassDebugID) & " terminated"
    #End If
End Sub

#If DebugMode Then
    Friend Property Get ClassDebugID() As Long
        ClassDebugID = lClassDebugID
    End Property
#End If

'Release me (ObjRef)
Public Sub releaseMe()
    Call Class_Terminate
    sTypeId = sNullTypeId
    lTProfSeqLen = 0
    Erase TProfs
    lSelectedProfile = -1
    Erase baObjKey
    iAddrCnt = 0
End Sub

'Initialies me (ObjRef) by URL
'IN:    sURL    e.g. "1.1@host:portno/key"
Friend Sub initByURL(ByVal Orb As cOrbImpl, _
    ByVal sURL As String, Optional ByVal sDefPort As String = "2809", _
    Optional ByVal TypeId As String = sNullTypeId)
    On Error GoTo ErrHandler
    
    Set oOrb = Orb
    'string type_id;
    sTypeId = TypeId

    'sAddrList/sObjKey
    Dim pos As Long
    Dim sAddrList As String
    Dim sObjKey As String
    pos = InStr(sURL & "/", "/")
    sAddrList = Left$(sURL, pos - 1)
    sObjKey = Mid$(sURL, pos + 1)
    
    '{octet major; octet minor} iiop_version;
    iIIOPVersion = &H100
    
    Dim sAddr As String
    Dim lNextPos As Long
    Do
        lNextPos = InStr(sAddrList, ",")
        If lNextPos = 0 Then
            sAddr = sAddrList
        Else
            sAddr = Left$(sAddrList, lNextPos - 1)
            sAddrList = Mid$(sAddrList, lNextPos + 1)
        End If
        
        '{octet major; octet minor} iiop_version;
        pos = InStr(sAddr, "@")
        If pos > 0 Then
            'sIIOPVersion = Left$(sAddr, pos - 1)
            iIIOPVersion = CInt(Mid$(sAddr, 1, 1)) * &H100        'IIOPVerMajor
            iIIOPVersion = iIIOPVersion + CInt(Mid$(sAddr, 3, 1)) 'IIOPVerMinor
            If iIIOPVersion < &H100 Or iIIOPVersion > &H102 Then
                Call mVBOrb.VBOrb.raiseINVOBJREF(1, mVBOrb.VBOrb.CompletedNO, _
                    "IIOP version " & Left$(sAddr, pos - 1) & " is unsupported")
            End If
            sAddr = Mid$(sAddr, pos + 1)
        End If
        
        'string host; unsigned short port;
        pos = InStr(sAddr, ":")
        Dim lPort As Long
        If pos = 0 Then
            sHosts(iAddrCnt) = sAddr
            On Error Resume Next
            lPort = CLng(sDefPort)
            If Err.Number <> 0 Then
                On Error GoTo ErrHandler 'Is calling Err.Clear()
                Call mVBOrb.ErrRaise(6, _
                    "Portnumber " & sDefPort & " is invalid")
            End If
            On Error GoTo ErrHandler
        Else
            sHosts(iAddrCnt) = Left$(sAddr, pos - 1)
            On Error Resume Next
            lPort = CLng(Mid$(sAddr, pos + 1))
            If Err.Number <> 0 Then
                On Error GoTo ErrHandler 'Is calling Err.Clear()
                Call mVBOrb.ErrRaise(6, _
                    "Portnumber " & Mid$(sAddr, pos + 1) & " is invalid")
            End If
            On Error GoTo ErrHandler
        End If
        If lPort < 0 Or lPort >= &H10000 Then
            Call mVBOrb.ErrRaise(6, _
                "Portnumber " & CStr(lPort) & " is out of range")
        End If
        iPorts(iAddrCnt) = IIf(lPort <= &H7FFF, lPort, lPort - &H10000)
        If sHosts(iAddrCnt) = "" Or sHosts(iAddrCnt) = "localhost" Then
            sHosts(iAddrCnt) = oOrb.localHost
        End If
        iAddrCnt = iAddrCnt + 1
    Loop Until lNextPos = 0
    
    If Len(sObjKey) > 0 Then
        'sequence <octet> object_key;
        'see objKey2String also
        Dim lKey As Long
        lKey = 0
        ReDim baObjKey(0 To Len(sObjKey) - 1)
        pos = 1
        Do
            If Mid$(sObjKey, pos, 1) = "%" Then
                baObjKey(lKey) = val("&H" & Mid$(sObjKey, pos + 1, 2))
                pos = pos + 3
            Else
                baObjKey(lKey) = Asc(Mid$(sObjKey, pos))
                pos = pos + 1
            End If
            lKey = lKey + 1
        Loop While pos <= Len(sObjKey)
        ReDim Preserve baObjKey(0 To lKey - 1)
    Else
        'UBound(baObjKey) = -1
        baObjKey = MidB(sObjKey, 1, 0)
    End If
    
    lTProfSeqLen = IIf(iAddrCnt > 0, 1, 0)
    lSelectedProfile = -1
    'Null object reference, is_nil()?
    If sTypeId = sNullTypeId And lTProfSeqLen = 0 Then
        Exit Sub
    End If
    
    ReDim TProfs(0 To lTProfSeqLen - 1)
    Dim iP As Long
    iP = 0
    TProfs(iP).ptag = TAG_INTERNET_IOP 'ProfileId

    Dim oPOut As cOrbStream
    Set oPOut = New cOrbStream
    Call oPOut.initStream(Orb, &H100, False)
    'sequence <octet> profile_data
    Call oPOut.writeEncapOpen(False)
    '{octet major; octet minor} iiop_version;
    Call oPOut.writeOctet(iIIOPVersion \ &H100)  'IIOPVerMajor
    Call oPOut.writeOctet(iIIOPVersion And &HFF) 'IIOPVerMinor
    'string host; unsigned short port;
    Call oPOut.writeString(sHosts(0))
    Call oPOut.writeUshort(iPorts(0))
    'sequence <octet> object_key;
    Call oPOut.writeSeqOctet(baObjKey, _
        UBound(baObjKey) - LBound(baObjKey) + 1)
    'Optional
    If iIIOPVersion = &H101 Or iIIOPVersion = &H102 Then
        'sequence <IOP::TaggedComponent> components;
        Dim iC As Long, TCLen As Long, iAddrIx As Long
        TCLen = iAddrCnt - 1
        iAddrIx = 1
        Call oPOut.writeUlong(TCLen)
        For iC = 0 To TCLen - 1
            'ComponentId tag
            Dim tagC As Long
            tagC = TAG_ALTERNATE_IIOP_ADDRESS
            Call oPOut.writeUlong(tagC)
            'sequence <octet> component_data;
            Call oPOut.writeEncapOpen(False)
            'string HostID; short Port;
            Call oPOut.writeString(sHosts(iAddrIx))
            Call oPOut.writeShort(iPorts(iAddrIx))
            iAddrIx = iAddrIx + 1
            Call oPOut.writeEncapClose
        Next iC
    End If
    Call oPOut.writeEncapClose
    Call oPOut.setPos(0)
    TProfs(iP).pdatlen = oPOut.readSeqOctet(TProfs(iP).pdata)
    Call oPOut.destroy
    lSelectedProfile = iP
    
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("initByURL")
End Sub

'Initialies me (ObjRef) by IOR stream or by one TaggedProfile
'IN:    bProfileOnly    Is used by "Read an object key of a request"
'RET:   True if reading a null object reference
Public Function initByIOR(ByVal Orb As cOrbImpl, ByVal oIn As cOrbStream, _
    Optional ByVal bProfileOnly As Boolean = False) As Boolean
    On Error GoTo ErrHandler
    Set oOrb = Orb
    If bProfileOnly Then
        sTypeId = sNullTypeId
        lTProfSeqLen = 1
    Else
        'string type_id; Example: IDL:TArbIdl/TConnFactory:1.0
        sTypeId = oIn.readString()
        'sequence <TaggedProfile> profiles;
        lTProfSeqLen = oIn.readUlong()
    End If
    
    lSelectedProfile = -1
    'Null object reference, is_nil()?
    If sTypeId = sNullTypeId And lTProfSeqLen = 0 Then
        initByIOR = True
        Exit Function
    End If
    
    ReDim TProfs(0 To lTProfSeqLen - 1) 'lTProfSeqLen must be > 0
    Dim iP As Integer
    For iP = 0 To lTProfSeqLen - 1
        'ProfileId tag
        TProfs(iP).ptag = oIn.readUlong()
        'sequence <octet> profile_data
        TProfs(iP).pdatlen = oIn.readSeqOctet(TProfs(iP).pdata)
        'Select a profile
        If TProfs(iP).ptag = TAG_INTERNET_IOP And lSelectedProfile < 0 Then
            Dim oPIn As New cOrbStream 'New is called only once!
            'Call oPIn.initByOctets(TProfs(iP).pdata, TProfs(iP).pdatlen, oOrb)
            Call oPIn.initStream(oOrb, &H100, TProfs(iP).pdatlen)
            Call oPIn.writeOctets(TProfs(iP).pdata, TProfs(iP).pdatlen)
            Call oPIn.setPos(0)
            'sequence <octet> profile_data
            Call oPIn.readEncapOpen(TProfs(iP).pdatlen)
            '{octet major; octet minor} iiop_version;
            iIIOPVersion = CInt(oPIn.readOctet()) * &H100        'IIOPVerMajor
            iIIOPVersion = iIIOPVersion + CInt(oPIn.readOctet()) 'IIOPVerMinor
            If iIIOPVersion = &H100 Or iIIOPVersion = &H101 _
                Or iIIOPVersion = &H102 Then
                'string host; unsigned short port;
                sHosts(iAddrCnt) = oPIn.readString()
                iPorts(iAddrCnt) = oPIn.readUshort()
                iAddrCnt = iAddrCnt + 1
                'sequence <octet> object_key;
                Call oPIn.readSeqOctet(baObjKey)
            Else
                Call mVBOrb.VBOrb.raiseMARSHAL(1, mVBOrb.VBOrb.CompletedNO, _
                    "IIOP version " & Hex$(iIIOPVersion) & " is unsupported")
            End If
            'Optional
            If iIIOPVersion = &H101 Or iIIOPVersion = &H102 Then
                'sequence <IOP::TaggedComponent> components;
                Dim iC As Long, TCLen As Long
                TCLen = oPIn.readUlong()
                For iC = 0 To TCLen - 1
                    'ComponentId tag
                    Dim tagC As Long
                    tagC = oPIn.readUlong()
                    'sequence <octet> component_data;
                    Dim CDLen As Long
                    CDLen = oPIn.readUlong()
                    If tagC = TAG_ALTERNATE_IIOP_ADDRESS Then
                        Call oPIn.readEncapOpen(CDLen)
                        'string HostID; short Port;
                        sHosts(iAddrCnt) = oPIn.readString()
                        iPorts(iAddrCnt) = oPIn.readShort()
                        iAddrCnt = iAddrCnt + 1
                        Call oPIn.readEncapClose
                    Else
                        'Skipping unknown component tag
                        Call oPIn.readSkip(CDLen)
                    End If
                Next iC
            End If
            Call oPIn.readEncapClose
            Call oPIn.destroy
            lSelectedProfile = iP
        End If
    Next iP
    Exit Function
ErrHandler:
    Call mVBOrb.ErrReraise("initByIOR")
End Function

'Writing the IOR of me
Public Sub writeMe(ByVal oOut As cOrbStream)
    
    If sTypeId = sNullTypeId Then
        If lTProfSeqLen = 0 Then 'Null object reference, is_nil()?
            'Null object references cannot write this way
            Call mVBOrb.ErrRaise(1, "Object has to be nothing")
        Else
            'Check to avoid difficult programming errors (remove if required)
            Call mVBOrb.ErrRaise(1, "Object has no IDL type_id")
        End If
        GoTo ExHandler
    End If
    
    'string type_id; example: IDL:foo/bar:1.0
    Call oOut.writeString(sTypeId)

    'sequence <TaggedProfile> profiles;
    Call oOut.writeUlong(lTProfSeqLen)
    Dim iP As Integer
    For iP = 0 To lTProfSeqLen - 1
        'ProfileId tag
        Call oOut.writeUlong(TProfs(iP).ptag)
        'sequence <octet> profile_data
        Call oOut.writeUlong(TProfs(iP).pdatlen)
        Call oOut.writeOctets(TProfs(iP).pdata, TProfs(iP).pdatlen)
    Next iP
    Exit Sub
ExHandler:
    Call mVBOrb.ErrReraise("writeMe")
End Sub

Public Property Get Orb() As cOrbImpl
    Set Orb = oOrb
End Property

Public Property Get objectKey() As String
    objectKey = oOrb.objKey2String(baObjKey)
End Property

Public Property Get TypeId() As String
    TypeId = sTypeId
End Property

Public Property Get IIOPAddress() As String
    'If LW tested and LW required then do it
    If oLWObjRef Is Nothing Then
        Dim i1 As Integer
        i1 = 0
        IIOPAddress = IIf(iAddrCnt = 0, "", getHostPort(i1))
        Do
            i1 = i1 + 1
            If i1 >= iAddrCnt Then
                Exit Do
            End If
            IIOPAddress = IIOPAddress & "," & getHostPort(i1)
        Loop
    Else
        IIOPAddress = oLWObjRef.IIOPAddress
    End If
End Property

Public Property Get IIOPVersion() As Integer
    'If LW tested and LW required then do it
    If oLWObjRef Is Nothing Then
        IIOPVersion = iIIOPVersion
    Else
        IIOPVersion = oLWObjRef.IIOPVersion
    End If
End Property

'is_nil(), Null object references are indicated by an empty set of profiles,
'and by a NullTypeID
Public Function isNil() As Boolean
    isNil = (sTypeId = sNullTypeId And lTProfSeqLen = 0)
End Function

'is_a(), Equivalence Checking Operation
Public Function isA(ByRef sRepId As String) As Boolean
    On Error GoTo ErrHandler
    If sTypeId = sRepId Then
        isA = True
        Exit Function
    End If
    Dim oRequest As cOrbRequest
    Set oRequest = Request("_is_a", False)
    Dim oOut As cOrbStream
    Set oOut = oRequest.InArg
    Call oOut.writeString(sRepId)
    Dim oIn As cOrbStream
    Call oRequest.invokeReqst(False)
    Set oIn = oRequest.OutRes
    isA = oIn.readBoolean()
    Exit Function
ErrHandler:
    Call mVBOrb.ErrReraise("isA")
End Function

'Helper
Public Sub narrow(ByRef sRepId As String)
    If Not isA(sRepId) Then
        Call mVBOrb.VBOrb.raiseUNKNOWN(1, mVBOrb.VBOrb.CompletedNO, _
            "Cannot narrow " & IIf(sTypeId = sNullTypeId, "ObjRef", _
            "[" & sTypeId & "]") & " to [" & sRepId & "]")
    End If
    If sTypeId = sNullTypeId Then
        sTypeId = sRepId
    End If
    'Exit Sub
'ErrHandler:
    'Call mvborb.ErrReraise("narrow") Is always called by narrow
End Sub

'unchecked_narrow(), interface helper
Public Sub uncheckedNarrow(ByRef sRepId As String)
    If sTypeId = sNullTypeId Then
        sTypeId = sRepId
    End If
End Sub

'non_existent(), Probing for Object Non-Existence
Public Function nonExistent() As Boolean
    On Error GoTo ErrHandler
    Dim oRequest As cOrbRequest
    Set oRequest = Request("_non_existent", False)
    Dim oOut As cOrbStream
    Set oOut = oRequest.InArg
    Dim oIn As cOrbStream
    Call oRequest.invokeReqst(False)
    Set oIn = oRequest.OutRes
    nonExistent = oIn.readBoolean()
    Exit Function
ErrHandler:
    Call mVBOrb.ErrReraise("nonExistent")
End Function

'Create request object and write request header
'(Do not call with oLWObjRef)
'IN:    Operation   Name of the operation
'IN:    OneWay      Is a oneway operation? (no response expected?)
'RET:               Request object
Public Function Request(ByRef Operation As String, ByVal OneWay As Boolean) _
    As cOrbRequest
    On Error GoTo ErrHandler
    
    Dim oOut As cOrbStream
    Set oOut = New cOrbStream
    'If not LW tested and Me.IIOPVersion < &h102 then LW test here
    'because otherwise Request Body remarshalling would be required
    If iLWCnt = 0 And (OneWay Or Me.IIOPVersion < &H102) Then
        'Locate Request
        Dim lwRequest As cOrbRequest
        Dim lwRequired As Boolean
        Dim oIn As cOrbStream
        Set oIn = New cOrbStream
        Dim newObjRef As cOrbObjRef
        Do
            If iLWCnt > LOCATION_FORWARD_LIMIT Then
                Call mVBOrb.VBOrb.raiseIMPLIMIT(1, mVBOrb.VBOrb.CompletedNO, _
                    "LOCATION_FORWARD_LIMIT")
            End If
            Set lwRequest = New cOrbRequest
            Call lwRequest.initRequest(Me, "", True, oOrb.getNextReqId(), _
                oOut)
            Call writeLocateReqst(oOut, lwRequest)
            'Call oOut.destroy 'in invokeLocateReqst()
            lwRequired = lwRequest.invokeReqst(True)
            iLWCnt = iLWCnt + 1
            If Not lwRequired Then
                Exit Do
            End If
            'readLocateReqstBody()
            Set oIn = lwRequest.OutRes
            'In GIOP version 1.2, the Reply Body is always aligned on an 8-octet
            'boundary. See also cOrbImpl.writeLocateReqstBody()
            If oIn.getGIOPVersion = &H102 Then Call oIn.align(8)
            Set newObjRef = lwRequest.OutRes.readObjRef()
            'Call newObjRef.narrow(sTypeId)
            If Not oLWObjRef Is Nothing Then Call oLWObjRef.releaseMe
            Set oLWObjRef = newObjRef
        Loop
    End If
    
    'Prepare GIOP Message Header
    Set Request = New cOrbRequest
    Call Request.initRequest(Me, Operation, Not OneWay, oOrb.getNextReqId(), _
        oOut)
    
    Call writeReqstHead(oOut, Request)
    Exit Function
ErrHandler:
    Call mVBOrb.ErrReraise("request")
End Function

'(Do not call with oLWObjRef)
'IN:    oOut        New cOrbStream
'IN:    oRequest
Private Sub writeLocateReqst(ByVal oOut As cOrbStream, _
    ByVal oRequest As cOrbRequest)
    On Error GoTo ErrHandler
    
    'GIOPVersion may be lower than Me.IIOPVersion
    Call oOut.initStream(oOrb, Me.IIOPVersion)
    Call oOut.sendGIOPPrepare
    
    'Write GIOP LocateRequest Header
    'unsigned long request_id
    Call oOut.writeUlong(oRequest.ReqId)
    'Write an object key of a request or a locate request
    Call writeTargetAddress(oOut)
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("writeLocateReqst")
End Sub

'(Do not call with oLWObjRef)
'IN:    oOut        New cOrbStream
Private Sub writeReqstHead(ByVal oOut As cOrbStream, _
    ByVal oRequest As cOrbRequest)
    On Error GoTo ErrHandler
    
    'GIOPVersion may be lower than Me.IIOPVersion
    Call oOut.initStream(oOrb, Me.IIOPVersion)
    Call oOut.sendGIOPPrepare
    
    'Write GIOP Request Header
    If oOut.getGIOPVersion <> &H102 Then
        'IOP::ServiceContextList service_context;
        Call oOut.writeUlong(0)
    End If
    'request_id; response_expected;
    Call oOut.writeUlong(oRequest.ReqId)
    Call oOut.writeBoolean(oRequest.ResponseExpected)
    If oOut.getGIOPVersion <> &H100 Then
        'octet reserved[3];
        Call oOut.writeOctet(0)
        Call oOut.writeOctet(0)
        Call oOut.writeOctet(0)
    End If
    'Write an object key of a request or a locate request
    Call writeTargetAddress(oOut)
    'operation;
    Call oOut.writeString(oRequest.Operation)
    If oOut.getGIOPVersion() <> &H102 Then
        'Principal (not in GIOP 1.2)
        Call oOut.writeUlong(0)
    Else
        'IOP::ServiceContextList service_context;
        Call oOut.writeUlong(0)
        'In GIOP version 1.2, the Request Body is always aligned on an 8-octet
        'boundary. The fact that GIOP specifies the maximum alignment for any
        'primitive type is 8 guarantees that the Request Body will not require
        'remarshaling if the Message or Request header are modified. The data
        'for the request body includes the following items:
        ' All in and inout parameters
        ' An optional Context pseudo object
        Call oOut.align(8)
    End If
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("writeReqstHead")
End Sub

'Write an object key of a request or a locate request
'Function is not private to allow calling with oLWObjRef
'IN:    oOut        cOrbStream
'GIN:   iAddrDisp
Friend Sub writeTargetAddress(ByVal oOut As cOrbStream)
    On Error GoTo ErrHandler
    If oOut.getGIOPVersion() <> &H102 Then
        'sequence <octet> object_key;
        Call oOut.writeSeqOctet(baObjKey, UBound(baObjKey) + 1)
    Else
        'TargetAddress target;
        Call oOut.writeShort(iAddrDisp)
        Select Case iAddrDisp
        Case 0 'KeyAddr, sequence <octet> object_key;
            Call oOut.writeSeqOctet(baObjKey, UBound(baObjKey) + 1)
        Case 1 'ProfileAddr, IOP::TaggedProfile profile;
            'ProfileId tag
            Call oOut.writeUlong(TProfs(lSelectedProfile).ptag)
            'sequence <octet> profile_data
            Call oOut.writeUlong(TProfs(lSelectedProfile).pdatlen)
            Call oOut.writeOctets(TProfs(lSelectedProfile).pdata, _
                TProfs(lSelectedProfile).pdatlen)
        Case 2 'ReferenceAddr, unsigned long selected_profile_index; IOP::IOR ior;
            Call oOut.writeUlong(lSelectedProfile)
            Call writeMe(oOut)
        Case Else
            Call mVBOrb.VBOrb.raiseMARSHAL(1, mVBOrb.VBOrb.CompletedNO, _
                "Unknown AddressingDisposition: " & CStr(iAddrDisp))
        End Select
    End If
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("writeTargetAddress")
End Sub

Private Function getHostPort(ByVal n As Integer) As String
    Dim lPort As Long
    lPort = iPorts(n)
    If lPort < 0 Then
        lPort = lPort + &H10000
    End If
    getHostPort = sHosts(n) & ":" & lPort
End Function

'Send a request or a locate request to address of ObjRef
'Function is not private to allow calling with oLWObjRef
'IN:    msgType      0 = Request, 2 = CancelRequest, 3 = LocateRequest
Friend Function sendReqst(ByVal Request As cOrbRequest, _
    ByVal msgType As Byte) As cOrbSocket
    On Error GoTo ErrHandler
    Dim bSameProcess As Boolean
    Dim oSock As cOrbSocket
    If lOrbConnId >= 0 Then 'Try last used address
        On Error Resume Next
        Set oSock = oOrb.ConnGet(bSameProcess, lOrbConnId, True)
        If Err.Number <> 0 Then
            Call oOrb.logErr("cOrbObjRef.sendReqst")
            On Error GoTo ErrLog
            Call oOrb.ConnOCIdFree(lOrbConnId, False)
            lOrbConnId = -1
            If iLWCnt > 0 Then
                iLWCnt = 0
                If Not oLWObjRef Is Nothing Then
                    Call oLWObjRef.releaseMe
                    Set oLWObjRef = Nothing
                End If
            End If
        End If
        On Error GoTo ErrHandler
    End If
    If lOrbConnId < 0 Then 'No address in use?
        If iAddrCnt = 0 Then
            Call mVBOrb.VBOrb.raiseINVOBJREF(1, mVBOrb.VBOrb.CompletedNO, _
                "IIOP address is missing")
        End If
        Dim i2 As Integer
        i2 = 0
        Do
            lOrbConnId = oOrb.ConnOCIdAlloc(getHostPort(i2))
            On Error Resume Next
            Set oSock = oOrb.ConnGet(bSameProcess, lOrbConnId, True)
            If Err.Number = 0 Then
                On Error GoTo ErrHandler
                Exit Do
            End If
            Call mVBOrb.ErrSave
            On Error GoTo ErrLog
            Call oOrb.ConnOCIdFree(lOrbConnId, False)
            lOrbConnId = -1
            i2 = i2 + 1
            If i2 >= iAddrCnt Then
                'On Error GoTo 0 : Call mvborb.ErrLoad
                GoTo ErrLoadRaise
            End If
            Call mVBOrb.ErrLoad
            On Error GoTo ErrHandler
        Loop
    End If
    If bSameProcess Then
        'same process (co-location)
        Call colocationMsg(Request, msgType)
        Set sendReqst = Nothing
        Exit Function
    End If
    On Error Resume Next
    Dim oOut As cOrbStream
    Set oOut = Request.InArg
    Call oOut.sendGIOPToSocket(msgType, oSock)
    If Err.Number <> 0 Then
        Call mVBOrb.ErrSave
        'WSAECONNABORTED or WSAECONNRESET
        If Err.Number = vbObjectError + 10053 Or _
            Err.Number = vbObjectError + 10054 Then
            On Error GoTo ErrLog
            'If you send oneway only, than "Connection aborted" is raised
            'To raise "connection refused" next time:
            Call oOrb.ConnOCIdFree(lOrbConnId, False)
            lOrbConnId = -1
        End If
        'On Error GoTo 0 : Call mvborb.ErrLoad
        GoTo ErrLoadRaise
    End If
    Set sendReqst = oSock
    Exit Function
ErrLog:
    Call oOrb.logErr("cOrbObjRef.sendReqst")
    Resume Next
ErrHandler:
    Call mVBOrb.ErrSave
    Resume ErrLoadRaise
ErrLoadRaise:
    On Error GoTo 0
    Call mVBOrb.ErrLoad
    Call mVBOrb.ErrReraise("sendReqst")
End Function

'IN:    msgType      0 = Request, 2 = CancelRequest, 3 = LocateRequest
Private Sub colocationMsg(ByVal Request As cOrbRequest, _
    ByVal msgType As Byte)
    On Error GoTo ErrHandler
    'Receive GIOP Message Header
    Dim oIn As cOrbStream
    Set oIn = Request.InArg
    Call oIn.setPos(12) 'Skip GIOP header
    Dim oOut As cOrbStream
    Select Case msgType
    Case 0 '= GIOP Request received
        Set oOut = New cOrbStream
        Call oOrb.replyRequest(oIn, oOut)
        If Not oOut Is Nothing Then
            '1 = Return Reply
            Call oOut.setPos(12) 'Skip GIOP header
            Call Request.setRes(1, oOut)
        End If
    'Case 1 '= GIOP Reply received
    'Case 2 '= CancelRequest received
    Case 3 '= Locate Request received
        Set oOut = New cOrbStream
        Call oOrb.replyLocateRequest(oIn, oOut)
        If Not oOut Is Nothing Then
            '4 = Send LocateReply
            Call oOut.setPos(12) 'Skip GIOP header
            Call Request.setRes(4, oOut)
        End If
    'Case 4 '= GIOP LocateReply received
    'Case 5 '5 = GIOP CloseConnection received
    'Case 6 '= MessageError received
    'case 7'= Fragment received
    Case Else
        Call mVBOrb.ErrRaise(1, "Unexpected GIOP msgType: " & msgType)
    End Select
Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("colocationMsg")
End Sub

'Receive a reply or a locate reply from address of ObjRef
'Function is not private to allow calling with oLWObjRef
Friend Function recvReply(ByVal Request As cOrbRequest, _
    ByVal recvTry As Boolean) As Boolean
    If Request.isRes Then
        recvReply = True
        Exit Function
    End If
    On Error Resume Next
    Call oOrb.ConnReqWait(lOrbConnId, Request) 'is calling Request.setRes()
    If Err.Number <> 0 Then
        Call mVBOrb.ErrSave
        'Close connection to get a new connection next time
        If Err.Number = vbObjectError + 10058 And recvTry Then 'WSAESHUTDOWN
            On Error GoTo ErrLog
            'Connection closed by Server
            Call oOrb.ConnOCIdFree(lOrbConnId, False)
            lOrbConnId = -1
            Call mVBOrb.ErrLoad 'Ignore old Error
            recvReply = False
            Exit Function
        End If
        'On Error GoTo 0 : Call mvborb.ErrLoad
        GoTo ErrLoadRaise
    End If
    recvReply = True
    Exit Function
ErrLog:
    Call oOrb.logErr("cOrbObjRef.recvReply")
    Resume Next
ErrLoadRaise:
    On Error GoTo 0
    Call mVBOrb.ErrLoad
    Call mVBOrb.ErrReraise("recvReply")
End Function

'Is called by Request.invokeReqst(), (Do not call with oLWObjRef)
'OUT:   Request.OutRes  Reply or Nothing
'RET:                   New IOR to read?
Public Function invokeLocateReqst(ByVal Request As cOrbRequest) As Boolean
    On Error GoTo ErrHandler
    Dim tryToRecv As Boolean
    tryToRecv = True
tryAgain:
    Dim oSock As cOrbSocket
    'If LW tested and LW required then do it
    If oLWObjRef Is Nothing Then
        Set oSock = sendReqst(Request, 3) '3 = LocateRequest
        
        If Not recvReply(Request, tryToRecv) Then
            tryToRecv = False
            GoTo tryAgain
        End If
    Else
        Set oSock = oLWObjRef.sendReqst(Request, 3) '3 = LocateRequest
        
        If Not oLWObjRef.recvReply(Request, tryToRecv) Then
            tryToRecv = False
            GoTo tryAgain
        End If
    End If
    
    'Receive GIOP Message Header
    Dim ReqId As Long, locStatus As Long
    Dim oIn As cOrbStream
    Set oIn = Request.OutRes
    'Read GIOP LocateReply Header
    'unsigned long request_id;
    ReqId = oIn.readUlong()
    'enum LocateStatusType;
    locStatus = oIn.readUlong()

    If ReqId <> Request.ReqId Then
        Call mVBOrb.VBOrb.raiseCOMMFAILURE(1, mVBOrb.VBOrb.CompletedNO, _
            "Unexpected RequestId: " & ReqId & " <> " & CStr(Request.ReqId))
    End If

    Select Case locStatus
    Case 0 '= UNKNOWN_OBJECT
        If oSock Is Nothing Then
            Call mVBOrb.VBOrb.raiseOBJECTNOTEXIST(1, mVBOrb.VBOrb.CompletedNO, _
                "UNKNOWN_OBJECT")
        Else
            Call mVBOrb.VBOrb.raiseOBJECTNOTEXIST(1, mVBOrb.VBOrb.CompletedNO, _
                "UNKNOWN_OBJECT at " & oSock.socketHost & ":" & oSock.socketPort)
        End If
    Case 1 '= OBJECT_HERE
        invokeLocateReqst = False
    Case 2 '= OBJECT_FORWARD
        invokeLocateReqst = True
    Case 3 '= OBJECT_FORWARD_PERM then Me.initByIOR???
        invokeLocateReqst = True
    Case 4 '= LOC_SYSTEM_EXCEPTION
        If oSock Is Nothing Then
            Call mVBOrb.readRaiseSystemEx(oIn, "ReqId= " & CStr(ReqId))
        Else
            Call mVBOrb.readRaiseSystemEx(oIn, _
                "Received from " & oSock.socketHost & ":" & oSock.socketPort _
                & ", ReqId= " & CStr(ReqId))
        End If
    'Case 5 '=LOC_NEEDS_ADDRESSING_MODE
    '???iAddrDisp=
    Case Else
        Call mVBOrb.VBOrb.raiseMARSHAL(1, mVBOrb.VBOrb.CompletedNO, _
            "Unknown locStatus: " & CStr(locStatus))
    End Select
    Call Request.InArg.destroy
    Exit Function
ErrLog:
    Call oOrb.logErr("cOrbObjRef.invokeLocateReqst")
    Resume Next
ErrHandler:
    Call mVBOrb.ErrSave
    Resume ErrCleanLoadRaise
ErrCleanLoadRaise:
    On Error GoTo ErrLog
    Call Request.InArg.destroy
    On Error GoTo 0
    Call mVBOrb.ErrLoad
    Call mVBOrb.ErrReraise("invokeLocateReqst")
End Function

'Is called by Request.invokeReqst(), (Do not call with oLWObjRef)
'The method name "invoke" is not allowed in VB
'IN:    Request.InArg   Request
'OUT:   Request.OutRes  Reply or Nothing
'RET:                   CORBA User Exception occured?
Public Function invokeReqst(ByVal Request As cOrbRequest) As Boolean
    On Error GoTo ErrHandler
    'locate requests if iLWCnt = 0 and message.size > xxx???
    Dim tryToRecv As Boolean
    tryToRecv = True
tryAgain:
    Dim oSock As cOrbSocket
    'If LW tested and LW required then do it
    If oLWObjRef Is Nothing Then
        Set oSock = sendReqst(Request, 0) '0 = Request
        'oneway?
        If Not Request.ResponseExpected Then
            invokeReqst = False
            Exit Function
        End If
        
        If Not recvReply(Request, tryToRecv) Then
            tryToRecv = False
            GoTo tryAgain
        End If
    Else
        Set oSock = oLWObjRef.sendReqst(Request, 0) '0 = Request
        'oneway?
        If Not Request.ResponseExpected Then
            invokeReqst = False
            Exit Function
        End If
        
        If Not oLWObjRef.recvReply(Request, tryToRecv) Then
            tryToRecv = False
            GoTo tryAgain
        End If
    End If
    'Receive GIOP Message Header
    Dim ReqId As Long, seqSC As Long, i1 As Long, repStatus As Long
    Dim oIn As cOrbStream
    Set oIn = Request.OutRes
    'Read GIOP Reply Header
    If oIn.getGIOPVersion <> &H102 Then
        'IOP::ServiceContextList service_context;
        seqSC = oIn.readUlong()
        For i1 = 1 To seqSC
            Call oIn.readUlong
            Call oIn.readSkip(oIn.readUlong())
        Next i1
        'unsigned long request_id;
        ReqId = oIn.readUlong()
        'ReplyStatusType reply_status;
        repStatus = oIn.readUlong()
    Else
        'unsigned long request_id;
        ReqId = oIn.readUlong()
        'ReplyStatusType reply_status;
        repStatus = oIn.readUlong()
        'IOP::ServiceContextList service_context;
        seqSC = oIn.readUlong()
        For i1 = 1 To seqSC
            '14 = ExceptionDetailMessage
            Call oIn.readUlong
            Call oIn.readSkip(oIn.readUlong())
        Next i1
    End If
    
    If ReqId <> Request.ReqId Then
        Call mVBOrb.ErrRaise(1, "Unexpected RequestId: " & ReqId & " <> " & Request.ReqId)
    End If

    If repStatus = 0 Then
        'NO_EXCEPTION
        invokeReqst = False
    ElseIf repStatus = 1 Then
        'USER_EXCEPTION
        invokeReqst = True
    ElseIf repStatus = 2 Then
        'SYSTEM_EXCEPTION
        If oSock Is Nothing Then
            Call mVBOrb.readRaiseSystemEx(oIn, "ReqId= " & CStr(ReqId))
        Else
            Call mVBOrb.readRaiseSystemEx(oIn, _
                "Received from " & oSock.socketHost & ":" & oSock.socketPort _
                & ", ReqId= " & CStr(ReqId))
        End If
    ElseIf repStatus = 3 Or repStatus = 4 Then
        'LOCATION_FORWARD, LOCATION_FORWARD_PERM
        If iLWCnt > LOCATION_FORWARD_LIMIT Then
            Call mVBOrb.VBOrb.raiseIMPLIMIT(1, mVBOrb.VBOrb.CompletedNO, _
                "LOCATION_FORWARD_LIMIT")
        End If
        iLWCnt = iLWCnt + 1
        'Get the new complete IOR
        Dim newObjRef As cOrbObjRef
        'if LOCATION_FORWARD_PERM then Me.initByIOR???
        Set newObjRef = oIn.readObjRef()
        'Call newObjRef.narrow(sTypeId)
        If Not oLWObjRef Is Nothing Then Call oLWObjRef.releaseMe
        Set oLWObjRef = newObjRef
        'If we get a LOCATION_FORWARD, we need to re-send the request and
        'to get hold of what was being sent in the original request
        Dim newRequest As cOrbRequest
        'Get previous request parameters and create new request
        Set newRequest = Me.Request(Request.Operation, _
            Not Request.ResponseExpected)
        Dim oOut As cOrbStream
        Set oOut = Request.InArg
        Call oOut.setPos(Request.ReqstBodyPos)
        Dim newOut As cOrbStream
        Set newOut = newRequest.InArg
        Call newOut.writeStream(oOut, oOut.Available)
        'The new request is baked and ready, so try again!
        invokeReqst = Me.invokeReqst(newRequest)
        'Start again with new info...
        'if LOCATION_FORWARD_PERM then GoTo tryAgain
    'ElseIf repStatus = 5 Then
        'NEEDS_ADDRESSING_MODE
        '???iAddrDisp=
    Else
        Call mVBOrb.VBOrb.raiseMARSHAL(1, mVBOrb.VBOrb.CompletedMAYBE, _
            "Unknown repStatus: " & CStr(repStatus))
    End If
    Call Request.InArg.destroy
    Exit Function
ErrLog:
    Call oOrb.logErr("cOrbObjRef.invokeReqst")
    Resume Next
ErrHandler:
    Call mVBOrb.ErrSave
    Resume ErrCleanLoadRaise
ErrCleanLoadRaise:
    On Error GoTo ErrLog
    Call Request.InArg.destroy
    On Error GoTo 0
    Call mVBOrb.ErrLoad
    Call mVBOrb.ErrReraise("invokeReqst")
End Function

