VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_ClientControlImplTie"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v096. Copyright (c) 1999 Martin.Both
'Source File Name: ../demos/callback/client.idl

Option Explicit

'You can use this class as a tie to your servant or as a servant example.
'Using as a tie:
' Your servant hat to implement c_ClientControl
' To activate a servant via tie write following:
'  Dim oClientControlImplTie As c_ClientControlImplTie
'  Set oClientControlImplTie = New c_ClientControlImplTie
'  Call oClientControlImplTie.setDelegate(oServant)
'  Call oOrb.Connect(oClientControlImplTie)
'Using as a servant example:
' Rename class to c_ClientControlImpl and save the file as c_ClientControlImpl.cls.
' Remove delegate stuff and write your own servant operations.
' To activate a servant write following:
'  Dim oClientControlImpl As c_ClientControlImpl
'  Set oClientControlImpl = New c_ClientControlImpl
'  Call oOrb.Connect(oClientControlImpl)

Implements cOrbSkeleton
Implements c_ClientControl

'interface ::Client::Control
Const sTypeId As String = "IDL:Client/Control:1.0"
Private oObjRef As cOrbObjRef
Private oDelegate As c_ClientControl

'Each tie contains a delegate object, to which all operations are forwarded.
'You can remove this if you use this class as an example for your servant.
Public Sub setDelegate(ByVal Delegate As c_ClientControl)
    Set oDelegate = Delegate
End Sub

Public Function getDelegate() As c_ClientControl
    Set getDelegate = oDelegate
End Function

Friend Property Get ObjRef() As cOrbObjRef
    Set ObjRef = oObjRef
End Property

Friend Property Get This() As c_ClientControl
    Dim oObj As cOrbObject
    Set oObj = New c_ClientControl
    If oObj.setObjRef(oObjRef, False) Then
        Set This = Nothing
    Else
        Set This = oObj
    End If
End Property

Private Property Get cOrbSkeleton_TypeId(ByVal Item As Integer) As String
    Select Case Item
    Case 0: cOrbSkeleton_TypeId = sTypeId
    Case 1: cOrbSkeleton_TypeId = "IDL:omg.org/CORBA/Object:1.0"
    End Select
End Property

Private Property Get cOrbSkeleton_ObjRef() As cOrbObjRef
    Set cOrbSkeleton_ObjRef = oObjRef
End Property

Private Property Set cOrbSkeleton_ObjRef(ByVal newObjRef As cOrbObjRef)
    Set oObjRef = newObjRef
End Property

'Helper
Private Function cOrbSkeleton_execute(ByVal sOperation As String, _
    ByVal oIn As cOrbStream, ByVal oOut As cOrbStream) As Long
    On Error GoTo ErrHandler
    Dim oImpl_ As c_ClientControl
    Set oImpl_ = IIf(oDelegate Is Nothing, Me, oDelegate)
    Select Case sOperation
    Case "setId"
        Dim a1_id As Long
        a1_id = oIn.readLong()
        Call oImpl_.setId(a1_id)
    Case "start"
        Call oImpl_.start
    Case "stop"
        Dim stopFunc As String
        stopFunc = oImpl_.stopFunc()
        Call oOut.writeString(stopFunc)
    Case Else
        Call VBOrb.raiseBADOPERATION(1, VBOrb.CompletedNO, sOperation)
    End Select
    cOrbSkeleton_execute = 0 'NO_EXCEPTION
    Exit Function
ErrHandler:
    Call VBOrb.ErrReraise("Control.execute(" & sOperation & ")")
End Function

'Implements c_ClientControl

'setId()
Private Sub c_ClientControl_setId(ByVal id As Long)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(1, VBOrb.CompletedNO)
    Else
        Call oDelegate.setId(id)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise("setId")
End Sub

'start()
Private Sub c_ClientControl_start()
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(1, VBOrb.CompletedNO)
    Else
        Call oDelegate.start
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise("start")
End Sub

'stop()
Private Function c_ClientControl_stopFunc() As String
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(1, VBOrb.CompletedNO)
    Else
        c_ClientControl_stopFunc = oDelegate.stopFunc()
    End If
    Exit Function
ErrHandler:
    Call VBOrb.ErrReraise("stopFunc")
End Function
