VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_ServerCounterImplTie"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v097. Copyright (c) 1999 Martin.Both
'Source File Name: ../demos/callback/server.idl

Option Explicit

'You can use this class as a tie to your servant or as a servant example.
'Using as a tie:
' Your servant hat to implement c_ServerCounter
' To activate a servant via tie write following:
'  Dim oServerCounterImplTie As c_ServerCounterImplTie
'  Set oServerCounterImplTie = New c_ServerCounterImplTie
'  Call oServerCounterImplTie.setDelegate(oServant)
'  Call oOrb.Connect(oServerCounterImplTie)
'Using as a servant example:
' Rename class to c_ServerCounterImpl and save the file as c_ServerCounterImpl.cls.
' Remove delegate stuff and write your own servant operations.
' To activate a servant write following:
'  Dim oServerCounterImpl As c_ServerCounterImpl
'  Set oServerCounterImpl = New c_ServerCounterImpl
'  Call oOrb.Connect(oServerCounterImpl)

Implements cOrbSkeleton
Implements c_ServerCounter

'interface ::Server::Counter
Const sTypeId As String = "IDL:Server/Counter:1.0"
Private oObjRef As cOrbObjRef
Private oDelegate As c_ServerCounter

'Each tie contains a delegate object, to which all operations are forwarded.
'You can remove this if you use this class as an example for your servant.
Public Sub setDelegate(ByVal Delegate As c_ServerCounter)
    Set oDelegate = Delegate
End Sub

Public Function getDelegate() As c_ServerCounter
    Set getDelegate = oDelegate
End Function

Friend Property Get ObjRef() As cOrbObjRef
    Set ObjRef = oObjRef
End Property

Friend Property Get This() As c_ServerCounter
    Dim oObj As cOrbObject
    Set oObj = New c_ServerCounter
    If oObj.setObjRef(oObjRef, False) Then
        Set This = Nothing
    Else
        Set This = oObj
    End If
End Property

Private Property Get cOrbSkeleton_TypeId(ByVal Item As Integer) As String
    Select Case Item
    Case 0: cOrbSkeleton_TypeId = sTypeId
    Case 1: cOrbSkeleton_TypeId = "IDL:omg.org/CORBA/Object:1.0"
    End Select
End Property

Private Property Get cOrbSkeleton_ObjRef() As cOrbObjRef
    Set cOrbSkeleton_ObjRef = oObjRef
End Property

Private Property Set cOrbSkeleton_ObjRef(ByVal newObjRef As cOrbObjRef)
    Set oObjRef = newObjRef
End Property

'Helper
Private Function cOrbSkeleton_execute(ByVal sOperation As String, _
    ByVal oIn As cOrbStream, ByVal oOut As cOrbStream) As Long
    On Error GoTo ErrHandler
    Dim oImpl_ As c_ServerCounter
    Set oImpl_ = IIf(oDelegate Is Nothing, Me, oDelegate)
    Select Case sOperation
    Case "_get_sum"
        Dim sum As Long
        sum = oImpl_.sum()
        Call oOut.writeLong(sum)
    Case "_set_sum"
        Dim sumNew As Long
        sumNew = oIn.readLong()
        oImpl_.sum() = sumNew
    Case "increment"
        Dim increment As Long
        increment = oImpl_.increment()
        Call oOut.writeLong(increment)
    Case Else
        Call VBOrb.raiseBADOPERATION(1, VBOrb.CompletedNO, sOperation)
    End Select
    cOrbSkeleton_execute = 0 'NO_EXCEPTION
    Exit Function
ErrHandler:
    Call VBOrb.ErrReraise(Err, "Counter.execute(" & sOperation & ")")
End Function

'Implements c_ServerCounter

'attribute sum
Private Property Get c_ServerCounter_sum() As Long
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(1, VBOrb.CompletedNO)
    Else
        c_ServerCounter_sum = oDelegate.sum
    End If
    Exit Property
ErrHandler:
    Call VBOrb.ErrReraise(Err, "sum.Get")
End Property

Private Property Let c_ServerCounter_sum(ByVal sumNew As Long)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(1, VBOrb.CompletedNO)
    Else
        oDelegate.sum = sumNew
    End If
    Exit Property
ErrHandler:
    Call VBOrb.ErrReraise(Err, "sum.Let")
End Property

'increment()
Private Function c_ServerCounter_increment() As Long
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(1, VBOrb.CompletedNO)
    Else
        c_ServerCounter_increment = oDelegate.increment()
    End If
    Exit Function
ErrHandler:
    Call VBOrb.ErrReraise(Err, "increment")
End Function
