VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_DBConnectionImplTie"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v099. Copyright (c) 1999 Martin.Both
'Source File Name: ../demos/db_query/database.idl

Option Explicit

'You can use this class as a tie to your servant or as a servant example.
'Using as a tie:
' Your servant has to implement c_DBConnection
' To activate a servant via tie write following:
'  Dim oDBConnectionImplTie As c_DBConnectionImplTie
'  Set oDBConnectionImplTie = New c_DBConnectionImplTie
'  Call oDBConnectionImplTie.setDelegate(oServant)
'  Call oOrb.Connect(oDBConnectionImplTie)
'Using as a servant example:
' Rename class to c_DBConnectionImpl and save the file as c_DBConnectionImpl.cls.
' Remove delegate stuff and write your own servant operations.
' To activate a servant write following:
'  Dim oDBConnectionImpl As c_DBConnectionImpl
'  Set oDBConnectionImpl = New c_DBConnectionImpl
'  Call oOrb.Connect(oDBConnectionImpl)

Implements cOrbSkeleton
Implements c_DBConnection

'interface ::DB::Connection
Const sTypeId As String = "IDL:DB/Connection:1.0"
Private oObjRef As cOrbObjRef
Private oDelegate As c_DBConnection

'Each tie contains a delegate object, to which all operations are forwarded.
'You can remove this if you use this class as an example for your servant.
Public Sub setDelegate(ByVal Delegate As c_DBConnection)
    Set oDelegate = Delegate
End Sub

Public Function getDelegate() As c_DBConnection
    Set getDelegate = oDelegate
End Function

Friend Property Get ObjRef() As cOrbObjRef
    Set ObjRef = oObjRef
End Property

Friend Property Get This() As c_DBConnection
    Dim oObj As cOrbObject
    Set oObj = New c_DBConnection
    If oObj.setObjRef(oObjRef, False) Then
        Set This = Nothing
    Else
        Set This = oObj
    End If
End Property

Private Property Get cOrbSkeleton_TypeId(ByVal Item As Integer) As String
    Select Case Item
    Case 0: cOrbSkeleton_TypeId = sTypeId
    Case 1: cOrbSkeleton_TypeId = "IDL:omg.org/CORBA/Object:1.0"
    End Select
End Property

Private Property Get cOrbSkeleton_ObjRef() As cOrbObjRef
    Set cOrbSkeleton_ObjRef = oObjRef
End Property

Private Property Set cOrbSkeleton_ObjRef(ByVal newObjRef As cOrbObjRef)
    Set oObjRef = newObjRef
End Property

'Helper
Private Function cOrbSkeleton_execute(ByVal sOperation As String, _
    ByVal oIn As cOrbStream, ByVal oOut As cOrbStream) As Long
    On Error GoTo ErrHandler
    Dim oImpl_ As c_DBConnection
    Set oImpl_ = IIf(oDelegate Is Nothing, Me, oDelegate)
    Select Case sOperation
    Case "close"
        Dim a1_warns As c_DBWarningSeq
        Call oImpl_.closeSub(a1_warns)
        Call a1_warns.writeMe(oOut, 0)
    Case "execute"
        Dim a2_stmstr As String
        a2_stmstr = oIn.readString()
        Dim a2_warns As c_DBWarningSeq
        Dim execute As Long
        execute = oImpl_.execute(a2_stmstr, a2_warns)
        Call oOut.writeLong(execute)
        Call a2_warns.writeMe(oOut, 0)
    Case "prepare"
        Dim a3_stmstr As String
        a3_stmstr = oIn.readString()
        Dim a3_warns As c_DBWarningSeq
        Dim prepare As c_DBStatement
        Set prepare = oImpl_.prepare(a3_stmstr, a3_warns)
        Call oOut.writeObject(prepare)
        Call a3_warns.writeMe(oOut, 0)
    Case "commit"
        Dim a4_warns As c_DBWarningSeq
        Call oImpl_.commit(a4_warns)
        Call a4_warns.writeMe(oOut, 0)
    Case "rollback"
        Dim a5_warns As c_DBWarningSeq
        Call oImpl_.rollback(a5_warns)
        Call a5_warns.writeMe(oOut, 0)
    Case Else
        Call VBOrb.raiseBADOPERATION(1, VBOrb.CompletedNO, sOperation)
    End Select
    cOrbSkeleton_execute = 0 'NO_EXCEPTION
    Exit Function
UserExWriter:
    Call VBOrb.getException().writeMe(oOut)
    cOrbSkeleton_execute = 1 'USER_EXCEPTION
    Exit Function
ErrHandler:
    If VBOrb.ErrIsUserEx() Then Resume UserExWriter
    Call VBOrb.ErrReraise(Err, "Connection.execute(" & sOperation & ")")
End Function

'Implements c_DBConnection

'close() raises(c_DBException)
Private Sub c_DBConnection_closeSub(ByRef warns As c_DBWarningSeq)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.closeSub(warns)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "closeSub")
End Sub

'execute() raises(c_DBException)
Private Function c_DBConnection_execute(ByVal stmstr As String, _
    ByRef warns As c_DBWarningSeq) As Long
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        c_DBConnection_execute = oDelegate.execute(stmstr, warns)
    End If
    Exit Function
ErrHandler:
    Call VBOrb.ErrReraise(Err, "execute")
End Function

'prepare() raises(c_DBException)
Private Function c_DBConnection_prepare(ByVal stmstr As String, _
    ByRef warns As c_DBWarningSeq) As c_DBStatement
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Set c_DBConnection_prepare = oDelegate.prepare(stmstr, warns)
    End If
    Exit Function
ErrHandler:
    Set c_DBConnection_prepare = Nothing
    Call VBOrb.ErrReraise(Err, "prepare")
End Function

'commit() raises(c_DBException)
Private Sub c_DBConnection_commit(ByRef warns As c_DBWarningSeq)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.commit(warns)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "commit")
End Sub

'rollback() raises(c_DBException)
Private Sub c_DBConnection_rollback(ByRef warns As c_DBWarningSeq)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.rollback(warns)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "rollback")
End Sub
