VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_DBManagerImplTie"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v099. Copyright (c) 1999 Martin.Both
'Source File Name: ../demos/db_query/database.idl

Option Explicit

'You can use this class as a tie to your servant or as a servant example.
'Using as a tie:
' Your servant has to implement c_DBManager
' To activate a servant via tie write following:
'  Dim oDBManagerImplTie As c_DBManagerImplTie
'  Set oDBManagerImplTie = New c_DBManagerImplTie
'  Call oDBManagerImplTie.setDelegate(oServant)
'  Call oOrb.Connect(oDBManagerImplTie)
'Using as a servant example:
' Rename class to c_DBManagerImpl and save the file as c_DBManagerImpl.cls.
' Remove delegate stuff and write your own servant operations.
' To activate a servant write following:
'  Dim oDBManagerImpl As c_DBManagerImpl
'  Set oDBManagerImpl = New c_DBManagerImpl
'  Call oOrb.Connect(oDBManagerImpl)

Implements cOrbSkeleton
Implements c_DBManager

'interface ::DB::Manager
Const sTypeId As String = "IDL:DB/Manager:1.0"
Private oObjRef As cOrbObjRef
Private oDelegate As c_DBManager

'Each tie contains a delegate object, to which all operations are forwarded.
'You can remove this if you use this class as an example for your servant.
Public Sub setDelegate(ByVal Delegate As c_DBManager)
    Set oDelegate = Delegate
End Sub

Public Function getDelegate() As c_DBManager
    Set getDelegate = oDelegate
End Function

Friend Property Get ObjRef() As cOrbObjRef
    Set ObjRef = oObjRef
End Property

Friend Property Get This() As c_DBManager
    Dim oObj As cOrbObject
    Set oObj = New c_DBManager
    If oObj.setObjRef(oObjRef, False) Then
        Set This = Nothing
    Else
        Set This = oObj
    End If
End Property

Private Property Get cOrbSkeleton_TypeId(ByVal Item As Integer) As String
    Select Case Item
    Case 0: cOrbSkeleton_TypeId = sTypeId
    Case 1: cOrbSkeleton_TypeId = "IDL:omg.org/CORBA/Object:1.0"
    End Select
End Property

Private Property Get cOrbSkeleton_ObjRef() As cOrbObjRef
    Set cOrbSkeleton_ObjRef = oObjRef
End Property

Private Property Set cOrbSkeleton_ObjRef(ByVal newObjRef As cOrbObjRef)
    Set oObjRef = newObjRef
End Property

'Helper
Private Function cOrbSkeleton_execute(ByVal sOperation As String, _
    ByVal oIn As cOrbStream, ByVal oOut As cOrbStream) As Long
    On Error GoTo ErrHandler
    Dim oImpl_ As c_DBManager
    Set oImpl_ = IIf(oDelegate Is Nothing, Me, oDelegate)
    Select Case sOperation
    Case "getConnection"
        Dim a1_url As String
        a1_url = oIn.readString()
        Dim a1_user As String
        a1_user = oIn.readString()
        Dim a1_password As String
        a1_password = oIn.readString()
        Dim a1_warns As c_DBWarningSeq
        Dim getConnection As c_DBConnection
        Set getConnection = oImpl_.getConnection(a1_url, a1_user, a1_password, _
            a1_warns)
        Call oOut.writeObject(getConnection)
        Call a1_warns.writeMe(oOut, 0)
    Case "shutdownServer"
        Call oImpl_.shutdownServer
    Case Else
        Call VBOrb.raiseBADOPERATION(1, VBOrb.CompletedNO, sOperation)
    End Select
    cOrbSkeleton_execute = 0 'NO_EXCEPTION
    Exit Function
UserExWriter:
    Call VBOrb.getException().writeMe(oOut)
    cOrbSkeleton_execute = 1 'USER_EXCEPTION
    Exit Function
ErrHandler:
    If VBOrb.ErrIsUserEx() Then Resume UserExWriter
    Call VBOrb.ErrReraise(Err, "Manager.execute(" & sOperation & ")")
End Function

'Implements c_DBManager

'getConnection() raises(c_DBException)
Private Function c_DBManager_getConnection(ByVal url As String, _
    ByVal user As String, ByVal password As String, _
    ByRef warns As c_DBWarningSeq) As c_DBConnection
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Set c_DBManager_getConnection = oDelegate.getConnection(url, user, _
            password, warns)
    End If
    Exit Function
ErrHandler:
    Set c_DBManager_getConnection = Nothing
    Call VBOrb.ErrReraise(Err, "getConnection")
End Function

'oneway shutdownServer()
Private Sub c_DBManager_shutdownServer()
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.shutdownServer
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "shutdownServer")
End Sub
