VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbAny"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Copyright (c) 2000 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.


'??? Any beinhaltet Funktionen wie:
'public abstract int extract_long() Throws BAD_OPERATION
'public abstract void insert_long(int l)

Option Explicit

Private oType As cOrbTypeCode
Private oOrigType As cOrbTypeCode
Private lOrigTcKind As Long 'Cache for oType.getOrigType().kind()
Private lCompCnt As Long 'Cache for component count

Private lCurPos As Long 'Selected component or -1

Private bVal As Boolean
Private cVal As Byte
Private iVal As Integer
Private lVal As Long
Private fVal As Single
Private dVal As Double
Private sVal As String
Private oVal As Object
Private vVal As Variant
Private oMemberVals() As cOrbAny

'Helper to read an any value using a TypeCode
Public Sub initByReadValue(ByVal oTC As cOrbTypeCode, ByVal oIn As cOrbStream)
    On Error GoTo ErrHandler
    Set oOrigType = oTC.getOrigType()
    lOrigTcKind = oOrigType.kind()
    lCompCnt = 0
    lCurPos = -1
    Select Case lOrigTcKind
    Case mCB.tk_null, mCB.tk_void
    Case mCB.tk_short
        iVal = oIn.readShort()
    Case mCB.tk_long
        lVal = oIn.readLong()
    Case mCB.tk_ushort
        iVal = oIn.readUshort()
    Case mCB.tk_ulong
        lVal = oIn.readUlong()
    Case mCB.tk_float
        fVal = oIn.readFloat()
    Case mCB.tk_double
        dVal = oIn.readDouble()
    Case mCB.tk_boolean
        bVal = oIn.readBoolean()
    Case mCB.tk_char
        cVal = oIn.readChar()
    Case mCB.tk_octet
        cVal = oIn.readOctet()
    Case mCB.tk_any
        Set oVal = oIn.readAny()
    Case mCB.tk_TypeCode
        Set oVal = oIn.readTypeCode()
    Case mCB.tk_Principal
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_objref
        Set oVal = oIn.readObject()
    Case mCB.tk_struct
        Dim lCnt As Long
        lCompCnt = oOrigType.memberCount()
        If lCompCnt > 0 Then
            ReDim oMemberVals(0 To lCompCnt - 1)
            lCurPos = 0
        End If
        For lCnt = 0 To lCompCnt - 1
            Set oMemberVals(lCnt) = New cOrbAny
            Call oMemberVals(lCnt).initByReadValue(oOrigType.memberType(lCnt), oIn)
        Next lCnt
    Case mCB.tk_union
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_enum
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_string
        sVal = oIn.readString()
    Case mCB.tk_sequence
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_array
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    'Case mCB.tk_alias cannot occur
    Case mCB.tk_except 'See struct???
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_longlong
        vVal = oIn.readLonglong()
    Case mCB.tk_ulonglong
        vVal = oIn.readUlonglong()
    Case mCB.tk_longdouble
        Set oVal = oIn.readLongdouble()
    Case mCB.tk_wchar
        iVal = oIn.readWchar()
    Case mCB.tk_wstring
        sVal = oIn.readWString()
    Case mCB.tk_fixed
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_value
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_value_box
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_native
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_abstract_interface, mCB.tk_local_interface
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case Else
        Call mVBOrb.VBOrb.raiseMARSHAL(0, mVBOrb.VBOrb.CompletedNO, _
            "TC.kind = " & CStr(lOrigTcKind))
    End Select
    Set oType = oTC
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("initByReadValue")
End Sub

'Helper to init an any value using a TypeCode
'For default values see: CORBA v2.6: Creating a DynAny Object
'Note DynAnyFactory.createDynAnyFromTypeCode(in CORBA::TypeCode type)
Public Sub initByDefaultValue(ByVal oTC As cOrbTypeCode)
    On Error GoTo ErrHandler
    Set oOrigType = oTC.getOrigType()
    lOrigTcKind = oOrigType.kind()
    lCompCnt = 0
    lCurPos = -1
    Select Case lOrigTcKind
    Case mCB.tk_null, mCB.tk_void
    Case mCB.tk_short
        iVal = 0
    Case mCB.tk_long
        lVal = 0&
    Case mCB.tk_ushort
        iVal = 0
    Case mCB.tk_ulong
        lVal = 0&
    Case mCB.tk_float
        fVal = 0!
    Case mCB.tk_double
        dVal = 0#
    Case mCB.tk_boolean
        bVal = False
    Case mCB.tk_char
        cVal = 0
    Case mCB.tk_octet
        cVal = 0
    Case mCB.tk_any
        Dim oAny As cOrbAny
        Set oAny = New cOrbAny
        Call oAny.initByDefaultValue(mVBOrb.VBOrb.tkNull())
        Set oVal = oAny
    Case mCB.tk_TypeCode
        Set oVal = mVBOrb.VBOrb.tkNull()
    Case mCB.tk_Principal
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_objref
        Set oVal = Nothing
    Case mCB.tk_struct
        Dim lCnt As Long
        lCompCnt = oOrigType.memberCount()
        If lCompCnt > 0 Then
            ReDim oMemberVals(0 To lCompCnt - 1)
            lCurPos = 0
        End If
        For lCnt = 0 To lCompCnt - 1
            Set oMemberVals(lCnt) = New cOrbAny
            Call oMemberVals(lCnt).initByDefaultValue(oOrigType.memberType(lCnt))
        Next lCnt
    Case mCB.tk_union
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_enum
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_string
        sVal = ""
    Case mCB.tk_sequence
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_array
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    'Case mCB.tk_alias cannot occur
    Case mCB.tk_except
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_longlong, mCB.tk_ulonglong
        Set vVal = CDec(0)
    Case mCB.tk_longdouble
        'Set oVal = New cOrblongdouble
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_wchar
        iVal = 0
    Case mCB.tk_wstring
        sVal = ""
    Case mCB.tk_fixed
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_value
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_value_box
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_native
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_abstract_interface, mCB.tk_local_interface
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case Else
        Call mVBOrb.VBOrb.raiseBADPARAM(0, mVBOrb.VBOrb.CompletedNO, _
            "TC.kind = " & CStr(lOrigTcKind))
    End Select
    Set oType = oTC
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("initByDefaultValue")
End Sub

'Helper to init an any value using a TypeCode
'Note DynAnyFactory.createDynAny(in any value)
Public Sub initByAnyValue(ByVal oAny As cOrbAny)
    On Error GoTo ErrHandler
    Set oOrigType = oAny.getType().getOrigType()
    lOrigTcKind = oOrigType.kind()
    lCompCnt = 0 '???oAny.componentCount()
    lCurPos = -1 '??? 0
    Select Case lOrigTcKind
        
    Case Else
        Call mVBOrb.VBOrb.raiseBADPARAM(0, mVBOrb.VBOrb.CompletedNO, _
            "TC.kind = " & CStr(lOrigTcKind))
    End Select
    Set oType = oAny.getType()
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("initByAnyValue")
End Sub

'Helper to write an any value using a TypeCode
Public Sub writeValue(ByVal oOut As cOrbStream)
    On Error GoTo ErrHandler
    Select Case lOrigTcKind
    Case mCB.tk_null, mCB.tk_void
    Case mCB.tk_short
        Call oOut.writeShort(iVal)
    Case mCB.tk_long
        Call oOut.writeLong(lVal)
    Case mCB.tk_ushort
        Call oOut.writeUshort(iVal)
    Case mCB.tk_ulong
        Call oOut.writeUlong(lVal)
    Case mCB.tk_float
        Call oOut.writeFloat(fVal)
    Case mCB.tk_double
        Call oOut.writeDouble(dVal)
    Case mCB.tk_boolean
        Call oOut.writeBoolean(bVal)
    Case mCB.tk_char
        Call oOut.writeChar(cVal)
    Case mCB.tk_octet
        Call oOut.writeOctet(cVal)
    Case mCB.tk_any
        Call oOut.writeAny(oVal)
    Case mCB.tk_TypeCode
        Call oOut.writeTypeCode(oVal)
    Case mCB.tk_Principal
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_objref
        Call oOut.writeObject(oVal)
    Case mCB.tk_struct
        Dim lCnt As Long
        For lCnt = 0 To lCompCnt - 1
            Call oMemberVals(lCnt).writeValue(oOut)
        Next lCnt
    Case mCB.tk_union
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_enum
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_string
        Call oOut.writeString(sVal)
    Case mCB.tk_sequence
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_array
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    'Case mCB.tk_alias cannot occur
    Case mCB.tk_except
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_longlong
        Call oOut.writeLonglong(vVal)
    Case mCB.tk_ulonglong
        Call oOut.writeUlonglong(vVal)
    Case mCB.tk_longdouble
        Call oOut.writeLongdouble(oVal)
    Case mCB.tk_wchar
        Call oOut.writeWchar(iVal)
    Case mCB.tk_wstring
        Call oOut.writeWString(sVal)
    Case mCB.tk_fixed
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_value
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_value_box
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_native
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case mCB.tk_abstract_interface, mCB.tk_local_interface
        Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
    Case Else
        Call mVBOrb.VBOrb.raiseMARSHAL(0, mVBOrb.VBOrb.CompletedNO, _
            "TC.kind = " & CStr(lOrigTcKind))
    End Select
    Exit Sub
ErrHandler:
    Call mVBOrb.ErrReraise("writeValue")
End Sub

'Get the TypeCode
'RET:   CORBA::TypeCode
Public Function getType() As cOrbTypeCode
    Set getType = oType
End Function

'Get the original TypeCode (without alias)
'RET:   CORBA::TypeCode
Public Function getOrigType() As cOrbTypeCode
    Set getOrigType = oOrigType
End Function

Public Function setPos(ByVal index As Long) As Boolean
    If index < 0 Or index >= lCompCnt Then
        lCurPos = -1
        setPos = False
    Else
        lCurPos = index
        setPos = True
    End If
End Function

Public Sub rewind()
    Call setPos(0)
End Sub

Public Function nextPos() As Boolean
    nextPos = setPos(lCurPos + 1)
End Function

Public Function componentCount() As Long
    componentCount = lCompCnt
End Function

'The returned any can be used to get/set the value of the current component.
Public Function currentComponent() As cOrbAny
    Set currentComponent = oMemberVals(lCurPos)
End Function

'Creates a new Any object whose value is a deep copy
Public Function copy() As cOrbAny
    Call mVBOrb.VBOrb.raiseNOIMPLEMENT(0, mVBOrb.VBOrb.CompletedNO)
End Function

Public Sub insertLong(ByVal val As Long)
    If lCurPos < 0 Then
        If lOrigTcKind <> mCB.tk_long Then
            Call mVBOrb.VBOrb.raiseBADPARAM(0, mVBOrb.VBOrb.CompletedNO)
        End If
        lVal = val
    Else
        Call oMemberVals(lCurPos).insertLong(val)
    End If
End Sub

Public Sub insertString(ByVal val As String)
    If lCurPos < 0 Then
        If lCompCnt > 0 Or lOrigTcKind <> mCB.tk_string Then
            Call mVBOrb.VBOrb.raiseBADPARAM(0, mVBOrb.VBOrb.CompletedNO)
        End If
        Dim maxLen As Long
        maxLen = oOrigType.Length
        If maxLen > 0 And Len(val) > maxLen Then
            Call mVBOrb.VBOrb.raiseBADPARAM(0, mVBOrb.VBOrb.CompletedNO)
        End If
        sVal = val
    Else
        Call oMemberVals(lCurPos).insertString(val)
    End If
End Sub

Public Function getLong() As Long
    If lCurPos < 0 Then
        If lOrigTcKind <> mCB.tk_long Then
            Call mVBOrb.VBOrb.raiseBADPARAM(0, mVBOrb.VBOrb.CompletedNO)
        End If
        getLong = lVal
    Else
        getLong = oMemberVals(lCurPos).getLong()
    End If
End Function

Public Function isString() As Boolean
    If lCurPos < 0 Then
        If lCompCnt > 0 Or lOrigTcKind <> mCB.tk_string Then
            isString = False
        Else
            isString = True
        End If
    Else
        isString = oMemberVals(lCurPos).isString()
    End If
End Function

Public Function getString() As String
    If lCurPos < 0 Then
        If lCompCnt > 0 Or lOrigTcKind <> mCB.tk_string Then
            Call mVBOrb.VBOrb.raiseBADPARAM(0, mVBOrb.VBOrb.CompletedNO)
        End If
        getString = sVal
    Else
        getString = oMemberVals(lCurPos).getString()
    End If
End Function

'Public Sub setShort(ByVal val As Integer)
'    lTypeCode = tk_short
'    iVal = val
'End Sub

'Public Function getShort() As Integer
'    getShort = iVal
'End Function
'Public Sub setUShort(ByVal val As Integer)
'    lTypeCode = tk_ushort
'    iVal = val
'End Sub

'Public Function getuShort() As Integer
'    getuShort = iVal
'End Function
'
'Public Sub setULong(ByVal val As Long)
'        lTypeCode = tk_ulong
'        lVal = val
'End Sub
'Public Sub setULongLong(ByVal val As Long)
'        lTypeCode = tk_ulonglong
'        lVal = val
'End Sub
'Public Sub setLongLong(ByVal val As Long)
'        lTypeCode = tk_longlong
'        lVal = val
'End Sub
'
'Public Function getULong() As Long
'    getULong = lVal
'End Function
'Public Function getULongLong() As Long
'    getULongLong = lVal
'End Function
'Public Function getLongLong() As Long
'    getLongLong = lVal
'End Function
'
'Public Sub setObjRef(ByVal name As String, ByVal val As cOrbObjRef)
'    lTypeCode = tk_objref
'    Set oVal = val
'    sTypeId = oVal.TypeId
'    sTypeName = name
'End Sub
'
'Public Function getObjRefName() As String
'    getObjRefName = sTypeName
'End Function
'
'Public Function getObjRef() As cOrbObjRef
'    Set getObjRef = oVal
'End Function
