VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cOrbRequest"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Copyright (c) 1999 Martin.Both

'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Library General Public
'License as published by the Free Software Foundation; either
'version 2 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
'Library General Public License for more details.

Option Explicit

'Set DebugMode = 0 to deactivate debug code in this class
#Const DebugMode = 0

#If DebugMode Then
    Private lClassDebugID As Long
#End If

'GIOP Request
'Is initialized?
Private oObjRef As cOrbObjRef
Private sOperation As String

Private lReqId As Long
Private bResponseExpected As Boolean
Private bResponseFlags As Byte

'Outgoing or incoming request stream
Private oReqsStream As cOrbStream
Private lReqstBodyPos As Long
'Incoming or outgoing reply stream
Private oReplStream As cOrbStream
Private iReplMsgType As Integer
Private bFinalResult As Boolean

'Use to handle more than one Request by the ORB
Public NextRequest As cOrbRequest

Private Sub Class_Initialize()
    #If DebugMode Then
        lClassDebugID = mVBOrb.getNextClassDebugID()
        Debug.Print "'" & TypeName(Me) & "' " & lClassDebugID & " initialized"
    #End If
End Sub

Private Sub Class_Terminate()
    'Release something which VB cannot know if required
    #If DebugMode Then
        Debug.Print "'" & TypeName(Me) & "' " & CStr(lClassDebugID) & " terminated"
    #End If
End Sub

#If DebugMode Then
    Friend Property Get ClassDebugID() As Long
        ClassDebugID = lClassDebugID
    End Property
#End If

'Initialization
'IN:    ObjRef              Target object
'IN:    Operation           Name of the operation
'IN:    ResponseExpected    Is not a oneway operation?
'IN:    ReqId               Request Id
'IN:    InArg               Or Nothing
Public Sub initRequest(ByVal ObjRef As cOrbObjRef, _
    ByRef Operation As String, ByVal ResponseExpected As Boolean, _
    ByVal ReqId As Long, ByVal InArg As cOrbStream)
    On Error GoTo ErrHandler
    If isInitialized() Then
        Call mVBOrb.VBOrb.raiseBADINVORDER(1, mVBOrb.VBOrb.CompletedNO)
    End If
    sOperation = Operation
    bResponseExpected = ResponseExpected
    'ResponseFlags: &H0 = oneway, &H1 = SyncScope.WITH_SERVER, &H3 = SyncScope.WITH_TARGET
    bResponseFlags = IIf(bResponseExpected, &H3, &H0)
    lReqId = ReqId
    Set oObjRef = ObjRef
    lReqstBodyPos = -1
    Set oReqsStream = InArg
    Exit Sub
ErrHandler:
    Set oObjRef = Nothing
    Call mVBOrb.ErrReraise("initRequest")
End Sub

'Is initialized?
Public Function isInitialized() As Boolean
    isInitialized = Not oObjRef Is Nothing
End Function

'Close OrbRequest to reinit it next time
Public Sub delete()
    If isInitialized() Then
        If Not oReqsStream Is Nothing Then
            Call oReqsStream.destroy
            Set oReqsStream = Nothing
        End If
        If Not oReplStream Is Nothing Then
            Call oReplStream.destroy
            Set oReplStream = Nothing
        End If
        Call oObjRef.releaseMe
        Set oObjRef = Nothing
    End If
End Sub

Public Function getTarget() As cOrbObjRef
    Set getTarget = oObjRef
End Function

Public Property Get Operation() As String
    Operation = sOperation
End Property

Public Property Get ResponseExpected() As Boolean
    ResponseExpected = bResponseExpected 'ResponseFlags() <> &H0
End Property

'ResponseFlags: &H0 = oneway, &H1 = SyncScope.WITH_SERVER, &H3 = SyncScope.WITH_TARGET
Public Property Get ResponseFlags() As Byte
    ResponseFlags = bResponseFlags
End Property

Public Property Get ReqId() As Long
    ReqId = lReqId
End Property

'RET:           Stream for input arguments
Public Property Get InArg() As cOrbStream
    If lReqstBodyPos = -1 Then
        lReqstBodyPos = oReqsStream.getPos()
    End If
    Set InArg = oReqsStream
End Property

Public Property Get ReqstBodyPos() As Long
    ReqstBodyPos = lReqstBodyPos
End Property

'RET:           UserException occured or LW required?
Public Function invokeReqst(ByVal HasUserExceptions As Boolean) As Boolean
    iReplMsgType = -1
    Set oReplStream = Nothing
    If Len(sOperation) = 0 Then
        invokeReqst = oObjRef.invokeLocateReqst(Me)
    Else
        invokeReqst = oObjRef.invokeReqst(Me)
    End If
    If invokeReqst And Not HasUserExceptions Then
        Call mVBOrb.VBOrb.raiseUNKNOWN(1, "Unknown USER_EXCEPTION")
    End If
    Set oObjRef = Nothing
End Function

'Set the result
'IN:    msgType     See cOrbImpl.ConnReqWait(), cOrbImpl.ConnClose(),
'                   cOrbImpl.ConnRecvMsg(), Me.OutRes()
'                   1, 2, 4, 1090, 1100
'IN.    oIn         Result or Nothing
Public Sub setRes(ByVal msgType As Integer, ByVal oIn As cOrbStream)
    If msgType = 7 Then
        Call oReplStream.addFragment(oIn)
        bFinalResult = Not oIn.areMoreFragments()
    Else
        iReplMsgType = msgType
        Set oReplStream = oIn
        If oIn Is Nothing Then
            bFinalResult = True
        Else
            bFinalResult = Not oIn.areMoreFragments()
        End If
    End If
End Sub

Public Function isRes() As Boolean
    isRes = (iReplMsgType >= 0 And bFinalResult)
End Function

'RET:   5 If CloseConnection received and we should reopen connection and send again
Public Function getResType() As Integer
    getResType = iReplMsgType
End Function

'Get the result stream
'Is called to read the reply header and is called to read the reply body
'RET:           Stream for Results and UserExceptions
Public Property Get OutRes() As cOrbStream
    If oReplStream Is Nothing Then
        Select Case iReplMsgType
        'Case 0 '= GIOP Request received
        'Case 1 '= GIOP Reply received
        'Case 2 '= CancelRequest received
        'Case 3 '= Locate Request received
        'Case 4 '= GIOP LocateReply received
        Case 5 '5 = GIOP CloseConnection received
            Call mVBOrb.VBOrb.raiseCOMMFAILURE(1, mVBOrb.VBOrb.CompletedMAYBE, _
                "CloseConnection received")
        Case 6 '= MessageError received
            Call mVBOrb.VBOrb.raiseCOMMFAILURE(1, mVBOrb.VBOrb.CompletedMAYBE, _
                "MessageError received")
        'case 7'= Fragment received
        'See cOrbImpl.ConnClose():
        Case 1006
            Call mVBOrb.VBOrb.raiseMARSHAL(0, mVBOrb.VBOrb.CompletedMAYBE, _
                "MsgErr")
        Case 1007
            Call mVBOrb.VBOrb.raiseCOMMFAILURE(0, mVBOrb.VBOrb.CompletedMAYBE, _
                "Unsupported GIOP fragment message")
        Case 1100
            Call mVBOrb.VBOrb.raiseTIMEOUT(0, mVBOrb.VBOrb.CompletedMAYBE, _
                "ReplyEndTime")
        Case Else
            Call mVBOrb.VBOrb.raiseCOMMFAILURE(1, mVBOrb.VBOrb.CompletedMAYBE, _
                "No Results")
        End Select
    End If
    Set OutRes = oReplStream
End Property

