VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_DBCursorImplTie"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v120. Copyright (c) 1999 Martin.Both
'Source File Name: ../demos/db_query/database.idl
'Target File Name: c_DBCursorImplTie.cls

Option Explicit

'You can use this class as a tie to your servant or as a servant example.
'Using as a tie:
' Your servant has to implement c_DBCursor
' To activate a servant via tie write following:
'  Dim oDBCursorImplTie As c_DBCursorImplTie
'  Set oDBCursorImplTie = New c_DBCursorImplTie
'  Call oDBCursorImplTie.setDelegate(oServant)
'  Call oOrb.Connect(oDBCursorImplTie)
'Using as a servant example:
' Rename class to c_DBCursorImpl and save the file as c_DBCursorImpl.cls.
' Remove delegate stuff and write your own servant operations.
' To activate a servant write following:
'  Dim oDBCursorImpl As c_DBCursorImpl
'  Set oDBCursorImpl = New c_DBCursorImpl
'  Call oOrb.Connect(oDBCursorImpl)

Implements cOrbSkeleton
Implements c_DBCursor

'interface ::DB::Cursor
Const sTypeId As String = "IDL:DB/Cursor:1.0"
Private oObjRef As cOrbObjRef
Private oDelegate As c_DBCursor

'Each tie contains a delegate object, to which all operations are forwarded.
'You can remove this if you use this class as an example for your servant.
Public Sub setDelegate(ByVal Delegate As c_DBCursor)
    Set oDelegate = Delegate
End Sub

Public Function getDelegate() As c_DBCursor
    Set getDelegate = oDelegate
End Function

Friend Property Get ObjRef() As cOrbObjRef
    Set ObjRef = oObjRef
End Property

Friend Property Get This() As c_DBCursor
    Dim oObj As cOrbObject
    Set oObj = New c_DBCursor
    If oObj.setObjRef(oObjRef, False) Then
        Set This = Nothing
    Else
        Set This = oObj
    End If
End Property

Private Property Get cOrbSkeleton_TypeId(ByVal Item As Integer) As String
    Select Case Item
    Case 0: cOrbSkeleton_TypeId = sTypeId
    Case 1: cOrbSkeleton_TypeId = "IDL:omg.org/CORBA/Object:1.0"
    End Select
End Property

Private Property Get cOrbSkeleton_ObjRef() As cOrbObjRef
    Set cOrbSkeleton_ObjRef = oObjRef
End Property

Private Property Set cOrbSkeleton_ObjRef(ByVal newObjRef As cOrbObjRef)
    Set oObjRef = newObjRef
End Property

'Helper
Private Function cOrbSkeleton_execute(ByVal sOperation As String, _
    ByVal oIn As cOrbStream, ByVal oOut As cOrbStream) As Long
    On Error GoTo ErrHandler
    Dim oImpl_ As c_DBCursor
    Set oImpl_ = IIf(oDelegate Is Nothing, Me, oDelegate)
    Select Case sOperation
    Case "open"
        Dim a1_using As c_DBColumnDataSeq
        Set a1_using = New c_DBColumnDataSeq
        Call a1_using.initByRead(oIn, 0)
        Dim a1_warns As c_DBMessageSeq
        Call oImpl_.openSub(a1_using, a1_warns)
        Call a1_warns.writeMe(oOut, 0)
    Case "fetch"
        Dim a2_func As Long
        a2_func = oIn.readLong()
        Dim a2_row As c_DBColumnDataSeq
        Dim a2_warns As c_DBMessageSeq
        Dim fetch As Long
        fetch = oImpl_.fetch(a2_func, a2_row, a2_warns)
        Call oOut.writeLong(fetch)
        Call a2_row.writeMe(oOut, 0)
        Call a2_warns.writeMe(oOut, 0)
    Case "fetchSet"
        Dim a3_rowcnt As Long
        a3_rowcnt = oIn.readLong()
        Dim a3_rows As c_DBColumnDataSeqSeq
        Dim a3_warns As c_DBMessageSeq
        Dim fetchSet As Long
        fetchSet = oImpl_.fetchSet(a3_rowcnt, a3_rows, a3_warns)
        Call oOut.writeLong(fetchSet)
        Call a3_rows.writeMe(oOut, 0)
        Call a3_warns.writeMe(oOut, 0)
    Case "close"
        Dim a4_warns As c_DBMessageSeq
        Call oImpl_.closeSub(a4_warns)
        Call a4_warns.writeMe(oOut, 0)
    Case "free"
        Dim a5_warns As c_DBMessageSeq
        Call oImpl_.free(a5_warns)
        Call a5_warns.writeMe(oOut, 0)
    Case Else
        Call VBOrb.raiseBADOPERATION(1, VBOrb.CompletedNO, sOperation)
    End Select
    cOrbSkeleton_execute = 0 'NO_EXCEPTION
    Exit Function
UserExWriter:
    Call VBOrb.getException().writeMe(oOut)
    cOrbSkeleton_execute = 1 'USER_EXCEPTION
    Exit Function
ErrHandler:
    If VBOrb.ErrIsUserEx() Then Resume UserExWriter
    Call VBOrb.ErrReraise(Err, "Cursor.execute(" & sOperation & ")")
End Function

'Implements c_DBCursor

'open() raises(c_DBErrMsgsEx)
Private Sub c_DBCursor_openSub(ByVal using As c_DBColumnDataSeq, _
    ByRef warns As c_DBMessageSeq)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.openSub(using, warns)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "openSub")
End Sub

'fetch() raises(c_DBErrMsgsEx)
Private Function c_DBCursor_fetch(ByVal func As Long, _
    ByRef row As c_DBColumnDataSeq, ByRef warns As c_DBMessageSeq) As Long
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        c_DBCursor_fetch = oDelegate.fetch(func, row, warns)
    End If
    Exit Function
ErrHandler:
    Call VBOrb.ErrReraise(Err, "fetch")
End Function

'fetchSet() raises(c_DBErrMsgsEx)
Private Function c_DBCursor_fetchSet(ByVal rowcnt As Long, _
    ByRef rows As c_DBColumnDataSeqSeq, ByRef warns As c_DBMessageSeq) As Long
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        c_DBCursor_fetchSet = oDelegate.fetchSet(rowcnt, rows, warns)
    End If
    Exit Function
ErrHandler:
    Call VBOrb.ErrReraise(Err, "fetchSet")
End Function

'close() raises(c_DBErrMsgsEx)
Private Sub c_DBCursor_closeSub(ByRef warns As c_DBMessageSeq)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.closeSub(warns)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "closeSub")
End Sub

'free() raises(c_DBErrMsgsEx)
Private Sub c_DBCursor_free(ByRef warns As c_DBMessageSeq)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.free(warns)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "free")
End Sub
