/*
   Copyright (c) 1999 Martin.Both
*/

package mboth.util;

/**
 * @author  Martin Both
 */

public class ArrayList
{
	/** The array
	 */
	private Object objs[];
	
	/** Size
	 */
	private int size;
	
	/** 
	 */
	public ArrayList()
	{
		objs= new Object[16];
		size= 0;
	}

	/**
	 */
	public int size()
	{
		return size;
	}
	
	/**
	 */
	public void add(Object obj)
	{
		if(size >= objs.length)
		{
			Object oldObjs[]= objs;
			objs= new Object[(size + 2) * 2];
			System.arraycopy(oldObjs, 0, objs, 0, size);
		}
		objs[size++]= obj;
	}
	
	/**
	 */
	public void insert(int index, Object obj)
	{
		if(size >= objs.length)
		{
			Object oldObjs[]= objs;
			objs= new Object[(size + 2) * 2];
			System.arraycopy(oldObjs, 0, objs, 0, index);
			System.arraycopy(oldObjs, index, objs, index + 1, size - index);
		}else
		{	System.arraycopy(objs, index, objs, index + 1, size - index);
		}
		size++;
		objs[index]= obj;
	}

	/**
	 */
	public void remove(int index)
	{
		objs[index]= null;
		size--;
		System.arraycopy(objs, index + 1, objs, index, size - index);
	}

	/**
	 */
	public Object get(int index)
	{
		if(index >= size)
			throw new IndexOutOfBoundsException(index + " >= " + size);

		return objs[index];
	}

	/**
	 */
	public void clear()
	{	while(size > 0)
		{	objs[--size]= null;
		}
	}
	
	/**
	 */
	public void copyInto(Object[] anArray)
	{
		System.arraycopy(objs, 0, anArray, 0, size);
	}

	/**
	 */
	public Object[] toArray()
	{
		if(size < objs.length)
		{
			Object oldObjs[]= objs;
			objs= new Object[size];
			System.arraycopy(oldObjs, 0, objs, 0, size);
		}
		return objs;
	}
}
