VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_BooleanSeq"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Generated by IDL2VB v120. Copyright (c) 1999 Martin.Both
'Source File Name: ../include/CORBA.idl
'Target File Name: c_BooleanSeq.cls

Option Explicit

Implements cOrbValueBase

'IDL Name: sequence<boolean>
'valuetype ::org::omg::boxedRMI::seq1_boolean
Const sTypeId As String = "RMI:[Z:0000000000000000"

Private seqLen As Long
Private seqBnd As Long
Private seqArr() As Boolean
Private seqIsDim As Boolean

Private lUniqueId As Long

Public Property Get Length() As Long
    Length = seqLen
End Property

Public Property Let Length(ByVal newLen As Long)
    On Error GoTo ErrHandler
    If newLen <= 0 Then
        seqLen = 0
        Erase seqArr
        seqIsDim = False
    Else
        If seqBnd > 0 And newLen > seqBnd Then
            Call mVBOrb.VBOrb.raiseBADPARAM(1, mVBOrb.VBOrb.CompletedNO, _
                CStr(newLen) & " > " & CStr(seqBnd))
        End If
        seqLen = newLen
        If seqIsDim Then
            If newLen > UBound(seqArr) + 1 Then
                Dim newSize As Long
                newSize = (UBound(seqArr) * 3& + 3&) \ 2&
                If seqBnd > 0 And newSize > seqBnd Then
                    newSize = seqBnd
                End If
                If newLen > newSize Then
                    newSize = newLen
                End If
                ReDim Preserve seqArr(0 To newSize - 1)
            End If
        Else
            ReDim seqArr(0 To newLen - 1)
            seqIsDim = True
        End If
    End If
    Exit Property
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "BooleanSeq.Length.Let")
End Property

Public Property Get Boundary() As Long
    Boundary = seqBnd
End Property

'index must be in the range of 0 to Length - 1
Public Property Get Item(ByVal index As Long) As Boolean
    On Error GoTo ErrHandler
    Item = seqArr(index)
    Exit Property
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "BooleanSeq.Item.Get")
End Property

'index must be in the range of 0 to Length - 1
Public Property Let Item(ByVal index As Long, ByVal Item As Boolean)
    On Error GoTo ErrHandler
    seqArr(index) = Item
    Exit Property
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "BooleanSeq.Item.Let")
End Property

Public Function getItems(ByRef Arr() As Boolean) As Long
    On Error GoTo ErrHandler
    getItems = seqLen
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        Arr(LBound(Arr) + seqCnt) = seqArr(seqCnt)
    Next seqCnt
    Exit Function
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "getItems")
End Function

Public Sub setItems(ByRef Arr() As Boolean, ByVal newLen As Long)
    On Error GoTo ErrHandler
    Me.Length = newLen
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        seqArr(seqCnt) = Arr(LBound(Arr) + seqCnt)
    Next seqCnt
    Exit Sub
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "setItems")
End Sub

'Helper
Public Sub initByRead(ByVal oIn As cOrbStream, ByVal maxLen As Long)
    On Error GoTo ErrHandler
    seqBnd = maxLen
    Dim newLen As Long
    newLen = oIn.readUlong()
    If seqBnd > 0 And newLen > seqBnd Then
        Call mVBOrb.VBOrb.raiseMARSHAL(1, mVBOrb.VBOrb.CompletedNO, _
            CStr(newLen) & " > " & CStr(seqBnd))
    End If
    seqIsDim = False
    Me.Length = newLen
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        seqArr(seqCnt) = oIn.readBoolean()
    Next seqCnt
    Exit Sub
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "BooleanSeq.read")
End Sub

'Helper
Public Sub writeMe(ByVal oOut As cOrbStream, ByVal maxLen As Long)
    On Error GoTo ErrHandler
    seqBnd = maxLen
    If seqBnd > 0 And seqLen > seqBnd Then
        Call mVBOrb.VBOrb.raiseMARSHAL(1, mVBOrb.VBOrb.CompletedNO, _
            CStr(seqLen) & " > " & CStr(seqBnd))
    End If
    Call oOut.writeUlong(seqLen)
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        Call oOut.writeBoolean(seqArr(seqCnt))
    Next seqCnt
    Exit Sub
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "BooleanSeq.write")
End Sub

'Helper
Public Sub initByAny(ByVal oAny As cOrbAny)
    On Error GoTo ErrHandler
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        seqArr(seqCnt) = oAny.getBoolean()
        Call oAny.nextPos
    Next seqCnt
    Exit Sub
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "initByAny")
End Sub

'Helper
Public Sub insertIntoAny(ByVal oAny As cOrbAny)
    On Error GoTo ErrHandler
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        Call oAny.insertBoolean(seqArr(seqCnt))
        Call oAny.nextPos
    Next seqCnt
    Exit Sub
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "insertIntoAny")
End Sub

'Helper to get different COM interface
Friend Function thisOrbValueBase() As cOrbValueBase
    Set thisOrbValueBase = Me
End Function

'Helper
Private Function cOrbValueBase_UniqueId() As Long
    If lUniqueId = 0 Then
        lUniqueId = mVBOrb.VBOrb.getNextUniqueID()
    End If
    cOrbValueBase_UniqueId = lUniqueId
End Function

'Helper
Private Sub cOrbValueBase_initByRead(ByVal oIn As cOrbStream)
    On Error GoTo ErrHandler
    Call initByRead(oIn, 0)
    Exit Sub
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "sequence.read")
End Sub

'Helper
Private Sub cOrbValueBase_writeMe(ByVal oOut As cOrbStream)
    On Error GoTo ErrHandler
    Call writeMe(oOut, 0)
    Exit Sub
ErrHandler:
    Call mVBOrb.VBOrb.ErrReraise(Err, "sequence.write")
End Sub

Private Function cOrbValueBase_getIds(ByVal Item As Integer) As String
    cOrbValueBase_getIds = IIf(Item = 0, sTypeId, "")
End Function

Private Function cOrbValueBase_isCustom() As Boolean
    cOrbValueBase_isCustom = False
End Function
