VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_LongSeq"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v121. Copyright (c) 1999-2003 Martin.Both
'Source File Name: ../demos/obv/valuebox/box.idl
'Target File Name: c_LongSeq.cls

Option Explicit

'IDL Name: sequence<long>

Private seqLen As Long
Private seqBnd As Long
Private seqArr() As Long
Private seqIsDim As Boolean

Public Property Get Length() As Long
    Length = seqLen
End Property

Public Property Let Length(ByVal newLen As Long)
    On Error GoTo ErrHandler
    If newLen <= 0 Then
        seqLen = 0
        Erase seqArr
        seqIsDim = False
    Else
        If seqBnd > 0 And newLen > seqBnd Then
            Call VBOrb.raiseBADPARAM(1, VBOrb.CompletedNO, _
                CStr(newLen) & " > " & CStr(seqBnd))
        End If
        seqLen = newLen
        If seqIsDim Then
            If newLen > UBound(seqArr) + 1 Then
                Dim newSize As Long
                newSize = (UBound(seqArr) * 3& + 3&) \ 2&
                If seqBnd > 0 And newSize > seqBnd Then
                    newSize = seqBnd
                End If
                If newLen > newSize Then
                    newSize = newLen
                End If
                ReDim Preserve seqArr(0 To newSize - 1)
            End If
        Else
            ReDim seqArr(0 To newLen - 1)
            seqIsDim = True
        End If
    End If
    Exit Property
ErrHandler:
    Call VBOrb.ErrReraise(Err, "LongSeq.Length.Let")
End Property

Public Property Get Boundary() As Long
    Boundary = seqBnd
End Property

'index must be in the range of 0 to Length - 1
Public Property Get Item(ByVal index As Long) As Long
    On Error GoTo ErrHandler
    Item = seqArr(index)
    Exit Property
ErrHandler:
    Call VBOrb.ErrReraise(Err, "LongSeq.Item.Get")
End Property

'index must be in the range of 0 to Length - 1
Public Property Let Item(ByVal index As Long, ByVal Item As Long)
    On Error GoTo ErrHandler
    seqArr(index) = Item
    Exit Property
ErrHandler:
    Call VBOrb.ErrReraise(Err, "LongSeq.Item.Let")
End Property

Public Function getItems(ByRef Arr() As Long) As Long
    On Error GoTo ErrHandler
    getItems = seqLen
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        Arr(LBound(Arr) + seqCnt) = seqArr(seqCnt)
    Next seqCnt
    Exit Function
ErrHandler:
    Call VBOrb.ErrReraise(Err, "getItems")
End Function

Public Sub setItems(ByRef Arr() As Long, ByVal newLen As Long)
    On Error GoTo ErrHandler
    Me.Length = newLen
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        seqArr(seqCnt) = Arr(LBound(Arr) + seqCnt)
    Next seqCnt
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "setItems")
End Sub

'Helper
Public Sub initByRead(ByVal oIn As cOrbStream, ByVal maxLen As Long)
    On Error GoTo ErrHandler
    seqBnd = maxLen
    Dim newLen As Long
    newLen = oIn.readUlong()
    If seqBnd > 0 And newLen > seqBnd Then
        Call VBOrb.raiseMARSHAL(1, VBOrb.CompletedNO, _
            CStr(newLen) & " > " & CStr(seqBnd))
    End If
    seqIsDim = False
    Me.Length = newLen
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        seqArr(seqCnt) = oIn.readLong()
    Next seqCnt
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "LongSeq.read")
End Sub

'Helper
Public Sub writeMe(ByVal oOut As cOrbStream, ByVal maxLen As Long)
    On Error GoTo ErrHandler
    seqBnd = maxLen
    If seqBnd > 0 And seqLen > seqBnd Then
        Call VBOrb.raiseMARSHAL(1, VBOrb.CompletedNO, _
            CStr(seqLen) & " > " & CStr(seqBnd))
    End If
    Call oOut.writeUlong(seqLen)
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        Call oOut.writeLong(seqArr(seqCnt))
    Next seqCnt
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "LongSeq.write")
End Sub

'Helper
Public Sub initByAny(ByVal oAny As cOrbAny)
    On Error GoTo ErrHandler
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        seqArr(seqCnt) = oAny.getLong()
        Call oAny.nextPos
    Next seqCnt
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "initByAny")
End Sub

'Helper
Public Sub insertIntoAny(ByVal oAny As cOrbAny)
    On Error GoTo ErrHandler
    Dim seqCnt As Long
    For seqCnt = 0 To seqLen - 1
        Call oAny.insertLong(seqArr(seqCnt))
        Call oAny.nextPos
    Next seqCnt
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "insertIntoAny")
End Sub
