VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "c_NmContextImplTie"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Generated by IDL2VB v121. Copyright (c) 1999-2003 Martin.Both
'Source File Name: ../naming/CosNaming.idl
'Target File Name: c_NmContextImplTie.cls

Option Explicit

'You can use this class as a tie to your servant or as a servant example.
'Using as a tie:
' Your servant has to implement c_NmContext
' To activate a servant via tie write following:
'  Dim oNmContextImplTie As c_NmContextImplTie
'  Set oNmContextImplTie = New c_NmContextImplTie
'  Call oNmContextImplTie.setDelegate(oServant)
'  Call oOrb.Connect(oNmContextImplTie)
'Using as a servant example:
' Rename class to c_NmContextImpl and save the file as c_NmContextImpl.cls.
' Remove delegate stuff and write your own servant operations.
' To activate a servant write following:
'  Dim oNmContextImpl As c_NmContextImpl
'  Set oNmContextImpl = New c_NmContextImpl
'  Call oOrb.Connect(oNmContextImpl)

Implements cOrbSkeleton
Implements c_NmContext

'interface ::CosNaming::NamingContext
Const sTypeId As String = "IDL:omg.org/CosNaming/NamingContext:1.0"
Private oObjRef As cOrbObjRef
Private oDelegate As c_NmContext

'Each tie contains a delegate object, to which all operations are forwarded.
'You can remove this if you use this class as an example for your servant.
Public Sub setDelegate(ByVal Delegate As c_NmContext)
    Set oDelegate = Delegate
End Sub

Public Function getDelegate() As c_NmContext
    Set getDelegate = oDelegate
End Function

Friend Property Get ObjRef() As cOrbObjRef
    Set ObjRef = oObjRef
End Property

Friend Property Get This() As c_NmContext
    Dim oObj As cOrbObject
    Set oObj = New c_NmContext
    If oObj.setObjRef(oObjRef, False) Then
        Set This = Nothing
    Else
        Set This = oObj
    End If
End Property

Private Property Get cOrbSkeleton_TypeId(ByVal Item As Integer) As String
    Select Case Item
    Case 0: cOrbSkeleton_TypeId = sTypeId
    Case 1: cOrbSkeleton_TypeId = "IDL:omg.org/CORBA/Object:1.0"
    End Select
End Property

Private Property Get cOrbSkeleton_ObjRef() As cOrbObjRef
    Set cOrbSkeleton_ObjRef = oObjRef
End Property

Private Property Set cOrbSkeleton_ObjRef(ByVal newObjRef As cOrbObjRef)
    Set oObjRef = newObjRef
End Property

'Helper
Private Function cOrbSkeleton_execute(ByVal sOperation As String, _
    ByVal oIn As cOrbStream, ByVal oOut As cOrbStream) As Long
    On Error GoTo ErrHandler
    Dim oImpl_ As c_NmContext
    Set oImpl_ = IIf(oDelegate Is Nothing, Me, oDelegate)
    Select Case sOperation
    Case "bind"
        Dim a1_n As c_NmNameComponentSeq
        Set a1_n = New c_NmNameComponentSeq
        Call a1_n.initByRead(oIn, 0)
        Dim a1_obj As cOrbObject
        Set a1_obj = oIn.readObject()
        Call oImpl_.bind(a1_n, a1_obj)
    Case "rebind"
        Dim a2_n As c_NmNameComponentSeq
        Set a2_n = New c_NmNameComponentSeq
        Call a2_n.initByRead(oIn, 0)
        Dim a2_obj As cOrbObject
        Set a2_obj = oIn.readObject()
        Call oImpl_.rebind(a2_n, a2_obj)
    Case "bind_context"
        Dim a3_n As c_NmNameComponentSeq
        Set a3_n = New c_NmNameComponentSeq
        Call a3_n.initByRead(oIn, 0)
        Dim a3_nc As c_NmContext
        Set a3_nc = m_NmContext.narrow(oIn.readObject())
        Call oImpl_.bindContext(a3_n, a3_nc)
    Case "rebind_context"
        Dim a4_n As c_NmNameComponentSeq
        Set a4_n = New c_NmNameComponentSeq
        Call a4_n.initByRead(oIn, 0)
        Dim a4_nc As c_NmContext
        Set a4_nc = m_NmContext.narrow(oIn.readObject())
        Call oImpl_.rebindContext(a4_n, a4_nc)
    Case "resolve"
        Dim a5_n As c_NmNameComponentSeq
        Set a5_n = New c_NmNameComponentSeq
        Call a5_n.initByRead(oIn, 0)
        Dim resolve As cOrbObject
        Set resolve = oImpl_.resolve(a5_n)
        Call oOut.writeObject(resolve)
    Case "unbind"
        Dim a6_n As c_NmNameComponentSeq
        Set a6_n = New c_NmNameComponentSeq
        Call a6_n.initByRead(oIn, 0)
        Call oImpl_.unbind(a6_n)
    Case "new_context"
        Dim newContext As c_NmContext
        Set newContext = oImpl_.newContext()
        Call oOut.writeObject(newContext)
    Case "bind_new_context"
        Dim a8_n As c_NmNameComponentSeq
        Set a8_n = New c_NmNameComponentSeq
        Call a8_n.initByRead(oIn, 0)
        Dim bindNewContext As c_NmContext
        Set bindNewContext = oImpl_.bindNewContext(a8_n)
        Call oOut.writeObject(bindNewContext)
    Case "destroy"
        Call oImpl_.destroy
    Case "list"
        Dim a10_how_many As Long
        a10_how_many = oIn.readUlong()
        Dim a10_bl As c_NmBindingSeq
        Dim a10_bi As c_NmBindingIterator
        Call oImpl_.list(a10_how_many, a10_bl, a10_bi)
        Call a10_bl.writeMe(oOut, 0)
        Call oOut.writeObject(a10_bi)
    Case Else
        Call VBOrb.raiseBADOPERATION(1, VBOrb.CompletedNO, sOperation)
    End Select
    cOrbSkeleton_execute = 0 'NO_EXCEPTION
    Exit Function
UserExWriter:
    Call VBOrb.getException().writeMe(oOut)
    cOrbSkeleton_execute = 1 'USER_EXCEPTION
    Exit Function
ErrHandler:
    If VBOrb.ErrIsUserEx() Then Resume UserExWriter
    Call VBOrb.ErrReraise(Err, "NamingContext.execute(" & sOperation & ")")
End Function

'Implements c_NmContext

'bind() raises(c_NmNotFoundEx, c_NmCannotProceedEx, c_NmInvalidNameEx, _
    c_NmAlreadyBoundEx)
Private Sub c_NmContext_bind(ByVal n As c_NmNameComponentSeq, _
    ByVal obj As cOrbObject)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.bind(n, obj)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "bind")
End Sub

'rebind() raises(c_NmNotFoundEx, c_NmCannotProceedEx, c_NmInvalidNameEx)
Private Sub c_NmContext_rebind(ByVal n As c_NmNameComponentSeq, _
    ByVal obj As cOrbObject)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.rebind(n, obj)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "rebind")
End Sub

'bind_context() raises(c_NmNotFoundEx, c_NmCannotProceedEx, c_NmInvalidNameEx, _
    c_NmAlreadyBoundEx)
Private Sub c_NmContext_bindContext(ByVal n As c_NmNameComponentSeq, _
    ByVal nc As c_NmContext)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.bindContext(n, nc)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "bindContext")
End Sub

'rebind_context() raises(c_NmNotFoundEx, c_NmCannotProceedEx, c_NmInvalidNameEx)
Private Sub c_NmContext_rebindContext(ByVal n As c_NmNameComponentSeq, _
    ByVal nc As c_NmContext)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.rebindContext(n, nc)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "rebindContext")
End Sub

'resolve() raises(c_NmNotFoundEx, c_NmCannotProceedEx, c_NmInvalidNameEx)
Private Function c_NmContext_resolve(ByVal n As c_NmNameComponentSeq) _
    As cOrbObject
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Set c_NmContext_resolve = oDelegate.resolve(n)
    End If
    Exit Function
ErrHandler:
    Set c_NmContext_resolve = Nothing
    Call VBOrb.ErrReraise(Err, "resolve")
End Function

'unbind() raises(c_NmNotFoundEx, c_NmCannotProceedEx, c_NmInvalidNameEx)
Private Sub c_NmContext_unbind(ByVal n As c_NmNameComponentSeq)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.unbind(n)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "unbind")
End Sub

'new_context()
Private Function c_NmContext_newContext() As c_NmContext
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Set c_NmContext_newContext = oDelegate.newContext()
    End If
    Exit Function
ErrHandler:
    Set c_NmContext_newContext = Nothing
    Call VBOrb.ErrReraise(Err, "newContext")
End Function

'bind_new_context() raises(c_NmNotFoundEx, c_NmAlreadyBoundEx, _
    c_NmCannotProceedEx, c_NmInvalidNameEx)
Private Function c_NmContext_bindNewContext(ByVal n As c_NmNameComponentSeq) _
    As c_NmContext
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Set c_NmContext_bindNewContext = oDelegate.bindNewContext(n)
    End If
    Exit Function
ErrHandler:
    Set c_NmContext_bindNewContext = Nothing
    Call VBOrb.ErrReraise(Err, "bindNewContext")
End Function

'destroy() raises(c_NmNotEmptyEx)
Private Sub c_NmContext_destroy()
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.destroy
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "destroy")
End Sub

'list()
Private Sub c_NmContext_list(ByVal how_many As Long, ByRef bl As c_NmBindingSeq, _
    ByRef bi As c_NmBindingIterator)
    On Error GoTo ErrHandler
    'Please write your own code here if using as servant example
    If oDelegate Is Nothing Then
        Call VBOrb.raiseNOIMPLEMENT(0, VBOrb.CompletedNO)
    Else
        Call oDelegate.list(how_many, bl, bi)
    End If
    Exit Sub
ErrHandler:
    Call VBOrb.ErrReraise(Err, "list")
End Sub
